/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.hibernate;

import io.opentelemetry.javaagent.instrumentation.hibernate.SessionInfo;

public class HibernateOperation {
    private final String spanName;
    private final String sessionId;

    public HibernateOperation(String operation, String entityName, SessionInfo sessionInfo) {
        this(HibernateOperation.spanNameForOperation(operation, entityName), sessionInfo);
    }

    public HibernateOperation(String operation, SessionInfo sessionInfo) {
        this.spanName = operation;
        this.sessionId = sessionInfo != null ? sessionInfo.getSessionId() : null;
    }

    public String getName() {
        return this.spanName;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    private static String spanNameForOperation(String operationName, String entityName) {
        if (entityName != null) {
            return operationName + " " + entityName;
        }
        return operationName;
    }
}

