/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.hibernate;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;

public class HibernateTracer
extends BaseTracer {
    private static final HibernateTracer TRACER = new HibernateTracer();

    public static HibernateTracer tracer() {
        return TRACER;
    }

    public Context startSpan(Context parentContext, String operationName, Object entity) {
        return this.startSpan(parentContext, this.spanNameForOperation(operationName, entity));
    }

    public Context startSpan(Context parentContext, String spanName) {
        return this.startSpan(parentContext, spanName, SpanKind.INTERNAL);
    }

    private String spanNameForOperation(String operationName, Object entity) {
        String entityName;
        if (entity != null && (entityName = this.entityName(entity)) != null) {
            return operationName + " " + entityName;
        }
        return operationName;
    }

    String entityName(Object entity) {
        if (entity == null) {
            return null;
        }
        String name = null;
        HashSet<String> annotations = new HashSet<String>();
        for (Annotation annotation : entity.getClass().getDeclaredAnnotations()) {
            annotations.add(annotation.annotationType().getName());
        }
        if (entity instanceof String) {
            name = (String)entity;
        } else if (annotations.contains("javax.persistence.Entity")) {
            name = entity.getClass().getName();
        } else if (entity instanceof List && !((List)entity).isEmpty()) {
            name = this.entityName(((List)entity).get(0));
        }
        return name;
    }

    protected String getInstrumentationName() {
        return "io.opentelemetry.javaagent.hibernate-common";
    }
}

