/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.hibernate;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.db.SqlStatementSanitizer;
import io.opentelemetry.javaagent.instrumentation.api.ContextStore;
import io.opentelemetry.javaagent.instrumentation.hibernate.HibernateTracer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SessionMethodUtils {
    public static final Set<String> SCOPE_ONLY_METHODS = new HashSet<String>(Arrays.asList("immediateLoad", "internalLoad"));

    public static <TARGET, ENTITY> Context startSpanFrom(ContextStore<TARGET, Context> contextStore, TARGET spanKey, String operationName, String entityName) {
        return SessionMethodUtils.startSpanFrom(contextStore, spanKey, () -> operationName, entityName);
    }

    private static <TARGET, ENTITY> Context startSpanFrom(ContextStore<TARGET, Context> contextStore, TARGET spanKey, Supplier<String> operationNameSupplier, String entityName) {
        Context sessionContext = (Context)contextStore.get(spanKey);
        if (sessionContext == null) {
            return null;
        }
        return HibernateTracer.tracer().startSpan(sessionContext, operationNameSupplier.get(), entityName);
    }

    public static <TARGET> Context startSpanFromQuery(ContextStore<TARGET, Context> contextStore, TARGET spanKey, String query) {
        Supplier<String> operationNameSupplier = () -> {
            String operation = "Hibernate Query";
            SqlStatementInfo info = SqlStatementSanitizer.sanitize((String)query);
            if (info.getOperation() != null) {
                operation = info.getOperation();
                if (info.getTable() != null) {
                    operation = operation + " " + info.getTable();
                }
            }
            return operation;
        };
        return SessionMethodUtils.startSpanFrom(contextStore, spanKey, operationNameSupplier, null);
    }

    public static void end(@Nullable Context context, Throwable throwable) {
        if (context == null) {
            return;
        }
        if (throwable != null) {
            HibernateTracer.tracer().endExceptionally(context, throwable);
        } else {
            HibernateTracer.tracer().end(context);
        }
    }

    public static <S, T> void attachSpanFromStore(ContextStore<S, Context> sourceContextStore, S source, ContextStore<T, Context> targetContextStore, T target) {
        Context sessionContext = (Context)sourceContextStore.get(source);
        if (sessionContext == null) {
            return;
        }
        targetContextStore.putIfAbsent(target, (Object)sessionContext);
    }

    public static String getSessionMethodSpanName(String methodName) {
        if ("fireLock".equals(methodName)) {
            return "Session.lock";
        }
        return "Session." + methodName;
    }

    public static String getEntityName(String descriptor, Object arg0, Object arg1, Function<Object, String> nameFromEntity) {
        String entityName = null;
        if (descriptor.startsWith("(Ljava/lang/String;Ljava/lang/Object;")) {
            entityName = arg0 == null ? nameFromEntity.apply(arg1) : (String)arg0;
        } else if (descriptor.startsWith("(Ljava/lang/Object;")) {
            entityName = nameFromEntity.apply(arg0);
        } else if (descriptor.startsWith("(Ljava/lang/String;")) {
            entityName = (String)arg0;
        } else if (descriptor.startsWith("(Ljava/lang/Class;") && arg0 != null) {
            entityName = ((Class)arg0).getName();
        }
        return entityName;
    }

    private SessionMethodUtils() {
    }
}

