/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.hibernate;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.db.SqlStatementSanitizer;
import io.opentelemetry.instrumentation.api.field.VirtualField;
import io.opentelemetry.javaagent.instrumentation.hibernate.HibernateSingletons;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public final class SessionMethodUtils {
    public static final Set<String> SCOPE_ONLY_METHODS = new HashSet<String>(Arrays.asList("immediateLoad", "internalLoad"));

    public static <TARGET> Context startSpanFrom(VirtualField<TARGET, Context> virtualField, TARGET spanKey, String operationName, String entityName) {
        return SessionMethodUtils.startSpanFrom(virtualField, spanKey, () -> operationName, entityName);
    }

    private static <TARGET> Context startSpanFrom(VirtualField<TARGET, Context> virtualField, TARGET spanKey, Supplier<String> operationNameSupplier, String entityName) {
        Context sessionContext = (Context)virtualField.get(spanKey);
        if (sessionContext == null) {
            return null;
        }
        return SessionMethodUtils.startSpanFrom(sessionContext, operationNameSupplier.get(), entityName);
    }

    public static Context startSpanFrom(Context sessionContext, String operationName, String entityName) {
        return HibernateSingletons.instrumenter().start(sessionContext, (Object)SessionMethodUtils.spanNameForOperation(operationName, entityName));
    }

    private static String spanNameForOperation(String operationName, String entityName) {
        if (entityName != null) {
            return operationName + " " + entityName;
        }
        return operationName;
    }

    public static <TARGET> Context startSpanFromQuery(VirtualField<TARGET, Context> virtualField, TARGET spanKey, String query) {
        Supplier<String> operationNameSupplier = () -> {
            String operation = "Hibernate Query";
            SqlStatementInfo info = SqlStatementSanitizer.sanitize((String)query);
            if (info.getOperation() != null) {
                operation = info.getOperation();
                if (info.getTable() != null) {
                    operation = operation + " " + info.getTable();
                }
            }
            return operation;
        };
        return SessionMethodUtils.startSpanFrom(virtualField, spanKey, operationNameSupplier, null);
    }

    public static void end(@Nullable Context context, Throwable throwable) {
        if (context == null) {
            return;
        }
        HibernateSingletons.instrumenter().end(context, null, null, throwable);
    }

    public static <S, T> void attachSpanFromStore(VirtualField<S, Context> sourceVirtualField, S source, VirtualField<T, Context> targetVirtualField, T target) {
        Context sessionContext = (Context)sourceVirtualField.get(source);
        if (sessionContext == null) {
            return;
        }
        targetVirtualField.set(target, (Object)sessionContext);
    }

    public static String getSessionMethodSpanName(String methodName) {
        if ("fireLock".equals(methodName)) {
            return "Session.lock";
        }
        return "Session." + methodName;
    }

    public static String getEntityName(String descriptor, Object arg0, Object arg1, Function<Object, String> nameFromEntity) {
        String entityName = null;
        if (descriptor.startsWith("(Ljava/lang/String;Ljava/lang/Object;")) {
            entityName = arg0 == null ? nameFromEntity.apply(arg1) : (String)arg0;
        } else if (descriptor.startsWith("(Ljava/lang/Object;")) {
            entityName = nameFromEntity.apply(arg0);
        } else if (descriptor.startsWith("(Ljava/lang/String;")) {
            entityName = (String)arg0;
        } else if (descriptor.startsWith("(Ljava/lang/Class;") && arg0 != null) {
            entityName = ((Class)arg0).getName();
        }
        return entityName;
    }

    private SessionMethodUtils() {
    }
}

