/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.hibernate;

import io.opentelemetry.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.db.SqlStatementSanitizer;
import java.util.function.Function;

public final class OperationNameUtil {
    public static String getOperationNameForQuery(String query) {
        String operation = "Hibernate Query";
        SqlStatementInfo info = SqlStatementSanitizer.sanitize((String)query);
        if (info.getOperation() != null) {
            operation = info.getOperation();
            if (info.getTable() != null) {
                operation = operation + " " + info.getTable();
            }
        }
        return operation;
    }

    public static String getSessionMethodOperationName(String methodName) {
        if ("fireLock".equals(methodName)) {
            return "Session.lock";
        }
        return "Session." + methodName;
    }

    public static String getEntityName(String descriptor, Object arg0, Object arg1, Function<Object, String> nameFromEntity) {
        String entityName = null;
        if (descriptor.startsWith("(Ljava/lang/String;Ljava/lang/Object;")) {
            entityName = arg0 == null ? nameFromEntity.apply(arg1) : (String)arg0;
        } else if (descriptor.startsWith("(Ljava/lang/Object;")) {
            entityName = nameFromEntity.apply(arg0);
        } else if (descriptor.startsWith("(Ljava/lang/String;")) {
            entityName = (String)arg0;
        } else if (descriptor.startsWith("(Ljava/lang/Class;") && arg0 != null) {
            entityName = ((Class)arg0).getName();
        }
        return entityName;
    }

    private OperationNameUtil() {
    }
}

