/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.annotation.support.async;

import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.annotation.support.async.AsyncOperationEndStrategy;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.checkerframework.checker.nullness.qual.Nullable;

public enum Jdk8AsyncOperationEndStrategy implements AsyncOperationEndStrategy
{
    INSTANCE;


    @Override
    public boolean supports(Class<?> asyncType) {
        return asyncType == CompletionStage.class || asyncType == CompletableFuture.class;
    }

    @Override
    public <REQUEST, RESPONSE> Object end(Instrumenter<REQUEST, RESPONSE> instrumenter, Context context, REQUEST request, Object asyncValue, Class<RESPONSE> responseType) {
        if (asyncValue instanceof CompletableFuture) {
            CompletableFuture future = (CompletableFuture)asyncValue;
            if (Jdk8AsyncOperationEndStrategy.tryToEndSynchronously(instrumenter, context, request, future, responseType)) {
                return future;
            }
            return Jdk8AsyncOperationEndStrategy.endWhenComplete(instrumenter, context, request, future, responseType);
        }
        CompletionStage stage = (CompletionStage)asyncValue;
        return Jdk8AsyncOperationEndStrategy.endWhenComplete(instrumenter, context, request, stage, responseType);
    }

    private static <REQUEST, RESPONSE> boolean tryToEndSynchronously(Instrumenter<REQUEST, RESPONSE> instrumenter, Context context, REQUEST request, CompletableFuture<?> future, Class<RESPONSE> responseType) {
        if (!future.isDone()) {
            return false;
        }
        try {
            Object potentialResponse = future.join();
            instrumenter.end(context, request, Jdk8AsyncOperationEndStrategy.tryToGetResponse(responseType, potentialResponse), null);
        }
        catch (Throwable t) {
            instrumenter.end(context, request, null, t);
        }
        return true;
    }

    private static <REQUEST, RESPONSE> CompletionStage<?> endWhenComplete(Instrumenter<REQUEST, RESPONSE> instrumenter, Context context, REQUEST request, CompletionStage<?> stage, Class<RESPONSE> responseType) {
        return stage.whenComplete((result, exception) -> instrumenter.end(context, request, Jdk8AsyncOperationEndStrategy.tryToGetResponse(responseType, result), exception));
    }

    private static <RESPONSE> @Nullable RESPONSE tryToGetResponse(Class<RESPONSE> responseType, Object result) {
        if (responseType.isInstance(result)) {
            return responseType.cast(result);
        }
        return null;
    }
}

