/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.annotation.support;

import io.opentelemetry.instrumentation.api.annotation.support.AttributeBinding;
import io.opentelemetry.instrumentation.api.annotation.support.AttributeBindingFactory;
import io.opentelemetry.instrumentation.api.annotation.support.AttributeBindings;
import io.opentelemetry.instrumentation.api.tracer.AttributeSetter;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class BaseAttributeBinder {
    public AttributeBindings bind(Method method) {
        AttributeBindings bindings = EmptyAttributeBindings.INSTANCE;
        Parameter[] parameters = method.getParameters();
        if (parameters == null || parameters.length == 0) {
            return bindings;
        }
        String[] attributeNames = this.attributeNamesForParameters(method, parameters);
        if (attributeNames == null || attributeNames.length != parameters.length) {
            return bindings;
        }
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            String attributeName = attributeNames[i];
            if (attributeName == null || attributeName.isEmpty()) continue;
            bindings = new CombinedAttributeBindings(bindings, i, AttributeBindingFactory.createBinding(attributeName, parameter.getParameterizedType()));
        }
        return bindings;
    }

    protected abstract @Nullable String[] attributeNamesForParameters(Method var1, Parameter[] var2);

    private static final class CombinedAttributeBindings
    implements AttributeBindings {
        private final AttributeBindings parent;
        private final int index;
        private final AttributeBinding binding;

        public CombinedAttributeBindings(AttributeBindings parent, int index, AttributeBinding binding) {
            this.parent = parent;
            this.index = index;
            this.binding = binding;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void apply(AttributeSetter setter, Object[] args) {
            Object arg;
            this.parent.apply(setter, args);
            if (args != null && args.length > this.index && (arg = args[this.index]) != null) {
                this.binding.apply(setter, arg);
            }
        }
    }

    protected static enum EmptyAttributeBindings implements AttributeBindings
    {
        INSTANCE;


        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void apply(AttributeSetter setter, Object[] args) {
        }
    }
}

