/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.tracer;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.instrumentation.api.tracer.utils.NetPeerUtils;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutionException;

public abstract class DatabaseClientTracer<CONNECTION, QUERY>
extends BaseTracer {
    protected static final String DB_QUERY = "DB Query";
    protected final Tracer tracer = GlobalOpenTelemetry.getTracer((String)this.getInstrumentationName(), (String)this.getVersion());

    public boolean shouldStartSpan(Context parentContext) {
        return this.shouldStartSpan(Span.Kind.CLIENT, parentContext);
    }

    public Context startSpan(Context parentContext, CONNECTION connection, QUERY query) {
        String normalizedQuery = this.normalizeQuery(query);
        Span span = this.tracer.spanBuilder(this.spanName(connection, query, normalizedQuery)).setParent(parentContext).setSpanKind(Span.Kind.CLIENT).setAttribute(SemanticAttributes.DB_SYSTEM, (Object)this.dbSystem(connection)).startSpan();
        if (connection != null) {
            this.onConnection(span, connection);
            this.setNetSemanticConvention(span, connection);
        }
        this.onStatement(span, normalizedQuery);
        return this.withClientSpan(parentContext, span);
    }

    @Override
    public Span getCurrentSpan() {
        return Span.current();
    }

    public void end(Context context) {
        Span.fromContext((Context)context).end();
    }

    public void endExceptionally(Context context, Throwable throwable) {
        Span span = Span.fromContext((Context)context);
        this.onError(span, throwable);
        this.end(span);
    }

    protected Span onConnection(Span span, CONNECTION connection) {
        span.setAttribute(SemanticAttributes.DB_USER, (Object)this.dbUser(connection));
        span.setAttribute(SemanticAttributes.DB_NAME, (Object)this.dbName(connection));
        span.setAttribute(SemanticAttributes.DB_CONNECTION_STRING, (Object)this.dbConnectionString(connection));
        return span;
    }

    @Override
    protected void onError(Span span, Throwable throwable) {
        if (throwable != null) {
            span.setStatus(StatusCode.ERROR);
            this.addThrowable(span, throwable instanceof ExecutionException ? throwable.getCause() : throwable);
        }
    }

    protected void setNetSemanticConvention(Span span, CONNECTION connection) {
        NetPeerUtils.INSTANCE.setNetPeer(span, this.peerAddress(connection));
    }

    protected void onStatement(Span span, String statement) {
        span.setAttribute(SemanticAttributes.DB_STATEMENT, (Object)statement);
    }

    protected abstract String normalizeQuery(QUERY var1);

    protected abstract String dbSystem(CONNECTION var1);

    protected String dbUser(CONNECTION connection) {
        return null;
    }

    protected String dbName(CONNECTION connection) {
        return null;
    }

    protected String dbConnectionString(CONNECTION connection) {
        return null;
    }

    protected abstract InetSocketAddress peerAddress(CONNECTION var1);

    protected String spanName(CONNECTION connection, QUERY query, String normalizedQuery) {
        if (normalizedQuery != null) {
            return normalizedQuery;
        }
        String result = null;
        if (connection != null) {
            result = this.dbName(connection);
        }
        return result == null ? DB_QUERY : result;
    }
}

