/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.tracer;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.instrumentation.api.config.Config;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SupportabilityMetrics {
    private static final Logger log = LoggerFactory.getLogger(SupportabilityMetrics.class);
    private final boolean agentDebugEnabled;
    private final Consumer<String> reporter;
    private final ConcurrentMap<String, KindCounters> suppressionCounters = new ConcurrentHashMap<String, KindCounters>();

    public SupportabilityMetrics(Config config) {
        this(config, arg_0 -> ((Logger)log).debug(arg_0));
    }

    SupportabilityMetrics(Config config, Consumer<String> reporter) {
        this.agentDebugEnabled = config.isAgentDebugEnabled();
        this.reporter = reporter;
    }

    void recordSuppressedSpan(SpanKind kind, String instrumentationName) {
        if (!this.agentDebugEnabled) {
            return;
        }
        this.suppressionCounters.computeIfAbsent(instrumentationName, s -> new KindCounters()).increment(kind);
    }

    void report() {
        this.suppressionCounters.forEach((instrumentationName, countsByKind) -> {
            for (SpanKind kind : SpanKind.values()) {
                long value = countsByKind.getAndReset(kind);
                if (value <= 0L) continue;
                this.reporter.accept("Suppressed Spans by '" + instrumentationName + "' (" + kind + ") : " + value);
            }
        });
    }

    SupportabilityMetrics start() {
        if (this.agentDebugEnabled) {
            Executors.newScheduledThreadPool(1, runnable -> {
                Thread result = new Thread(runnable, "supportability_metrics_reporter");
                result.setDaemon(true);
                return result;
            }).scheduleAtFixedRate(this::report, 5L, 5L, TimeUnit.SECONDS);
        }
        return this;
    }

    private static class KindCounters {
        private final LongAdder server = new LongAdder();
        private final LongAdder client = new LongAdder();
        private final LongAdder internal = new LongAdder();
        private final LongAdder consumer = new LongAdder();
        private final LongAdder producer = new LongAdder();

        private KindCounters() {
        }

        void increment(SpanKind kind) {
            switch (kind) {
                case INTERNAL: {
                    this.internal.increment();
                    break;
                }
                case SERVER: {
                    this.server.increment();
                    break;
                }
                case CLIENT: {
                    this.client.increment();
                    break;
                }
                case PRODUCER: {
                    this.producer.increment();
                    break;
                }
                case CONSUMER: {
                    this.consumer.increment();
                    break;
                }
            }
        }

        long getAndReset(SpanKind kind) {
            switch (kind) {
                case INTERNAL: {
                    return this.internal.sumThenReset();
                }
                case SERVER: {
                    return this.server.sumThenReset();
                }
                case CLIENT: {
                    return this.client.sumThenReset();
                }
                case PRODUCER: {
                    return this.producer.sumThenReset();
                }
                case CONSUMER: {
                    return this.consumer.sumThenReset();
                }
            }
            return 0L;
        }
    }
}

