/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.cache;

import io.opentelemetry.instrumentation.api.cache.Cache;
import io.opentelemetry.instrumentation.api.cache.internal.weaklockfree.WeakConcurrentMap;
import java.util.function.Function;

final class WeakLockFreeCache<K, V>
implements Cache<K, V> {
    private final WeakConcurrentMap<K, V> delegate = new WeakConcurrentMap.WithInlinedExpunction();

    WeakLockFreeCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V value = this.get(key);
        if (value != null) {
            return value;
        }
        WeakConcurrentMap<K, V> weakConcurrentMap = this.delegate;
        synchronized (weakConcurrentMap) {
            value = this.get(key);
            if (value != null) {
                return value;
            }
            value = mappingFunction.apply(key);
            Object previous = this.delegate.putIfAbsent((Object)key, (Object)value);
            if (previous != null) {
                return (V)previous;
            }
            return value;
        }
    }

    @Override
    public V get(K key) {
        return (V)this.delegate.getIfPresent((Object)key);
    }

    @Override
    public void put(K key, V value) {
        this.delegate.put((Object)key, (Object)value);
    }

    @Override
    public void remove(K key) {
        this.delegate.remove((Object)key);
    }

    int size() {
        return this.delegate.approximateSize();
    }
}

