/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.annotations.UnstableApi;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ClientInstrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.instrumentation.api.instrumenter.RequestMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.ServerInstrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKeyExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanSuppressionStrategy;
import io.opentelemetry.instrumentation.api.instrumenter.TimeExtractor;
import io.opentelemetry.instrumentation.api.internal.SpanKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public final class InstrumenterBuilder<REQUEST, RESPONSE> {
    private static final boolean ENABLE_SPAN_SUPPRESSION_BY_TYPE = Config.get().getBoolean("otel.instrumentation.experimental.outgoing-span-suppression-by-type", false);
    final OpenTelemetry openTelemetry;
    final Meter meter;
    final String instrumentationName;
    final String instrumentationVersion;
    final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    final List<SpanLinksExtractor<? super REQUEST>> spanLinksExtractors = new ArrayList<SpanLinksExtractor<? super REQUEST>>();
    final List<AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors = new ArrayList<AttributesExtractor<? super REQUEST, ? super RESPONSE>>();
    final List<ContextCustomizer<? super REQUEST>> contextCustomizers = new ArrayList<ContextCustomizer<? super REQUEST>>();
    final List<RequestListener> requestListeners = new ArrayList<RequestListener>();
    final List<RequestListener> requestMetricListeners = new ArrayList<RequestListener>();
    SpanKindExtractor<? super REQUEST> spanKindExtractor = SpanKindExtractor.alwaysInternal();
    SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor = SpanStatusExtractor.getDefault();
    ErrorCauseExtractor errorCauseExtractor = ErrorCauseExtractor.jdk();
    @Nullable
    TimeExtractor<REQUEST, RESPONSE> timeExtractor = null;
    boolean disabled = false;
    private boolean enableSpanSuppressionByType = ENABLE_SPAN_SUPPRESSION_BY_TYPE;

    InstrumenterBuilder(OpenTelemetry openTelemetry, String instrumentationName, String instrumentationVersion, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        this.openTelemetry = openTelemetry;
        this.meter = openTelemetry.getMeterProvider().get(instrumentationName);
        this.instrumentationName = instrumentationName;
        this.instrumentationVersion = instrumentationVersion;
        this.spanNameExtractor = spanNameExtractor;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setSpanStatusExtractor(SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor) {
        this.spanStatusExtractor = spanStatusExtractor;
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractor(AttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor) {
        this.attributesExtractors.add(attributesExtractor);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractors(Iterable<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors) {
        attributesExtractors.forEach(this.attributesExtractors::add);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractors(AttributesExtractor<? super REQUEST, ? super RESPONSE> ... attributesExtractors) {
        return this.addAttributesExtractors(Arrays.asList(attributesExtractors));
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addSpanLinksExtractor(SpanLinksExtractor<REQUEST> spanLinksExtractor) {
        this.spanLinksExtractors.add(spanLinksExtractor);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addContextCustomizer(ContextCustomizer<? super REQUEST> contextCustomizer) {
        this.contextCustomizers.add(contextCustomizer);
        return this;
    }

    @UnstableApi
    public InstrumenterBuilder<REQUEST, RESPONSE> addRequestMetrics(RequestMetrics factory) {
        this.requestMetricListeners.add(factory.create(this.meter));
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setErrorCauseExtractor(ErrorCauseExtractor errorCauseExtractor) {
        this.errorCauseExtractor = errorCauseExtractor;
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setTimeExtractor(TimeExtractor<REQUEST, RESPONSE> timeExtractor) {
        this.timeExtractor = Objects.requireNonNull(timeExtractor);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    InstrumenterBuilder<REQUEST, RESPONSE> enableInstrumentationTypeSuppression(boolean enableInstrumentationType) {
        this.enableSpanSuppressionByType = enableInstrumentationType;
        return this;
    }

    public Instrumenter<REQUEST, RESPONSE> newClientInstrumenter(TextMapSetter<REQUEST> setter) {
        return this.newInstrumenter(InstrumenterConstructor.propagatingToDownstream(setter), SpanKindExtractor.alwaysClient());
    }

    public Instrumenter<REQUEST, RESPONSE> newServerInstrumenter(TextMapGetter<REQUEST> getter) {
        return this.newInstrumenter(InstrumenterConstructor.propagatingFromUpstream(getter), SpanKindExtractor.alwaysServer());
    }

    public Instrumenter<REQUEST, RESPONSE> newProducerInstrumenter(TextMapSetter<REQUEST> setter) {
        return this.newInstrumenter(InstrumenterConstructor.propagatingToDownstream(setter), SpanKindExtractor.alwaysProducer());
    }

    public Instrumenter<REQUEST, RESPONSE> newConsumerInstrumenter(TextMapGetter<REQUEST> getter) {
        return this.newInstrumenter(InstrumenterConstructor.propagatingFromUpstream(getter), SpanKindExtractor.alwaysConsumer());
    }

    public Instrumenter<REQUEST, RESPONSE> newInstrumenter() {
        return this.newInstrumenter(InstrumenterConstructor.internal(), SpanKindExtractor.alwaysInternal());
    }

    public Instrumenter<REQUEST, RESPONSE> newInstrumenter(SpanKindExtractor<? super REQUEST> spanKindExtractor) {
        return this.newInstrumenter(InstrumenterConstructor.internal(), spanKindExtractor);
    }

    private Instrumenter<REQUEST, RESPONSE> newInstrumenter(InstrumenterConstructor<REQUEST, RESPONSE> constructor, SpanKindExtractor<? super REQUEST> spanKindExtractor) {
        this.spanKindExtractor = spanKindExtractor;
        return constructor.create(this);
    }

    SpanSuppressionStrategy getSpanSuppressionStrategy() {
        Set<SpanKey> spanKeys = SpanKeyExtractor.determineSpanKeys(this.attributesExtractors);
        if (this.enableSpanSuppressionByType) {
            return SpanSuppressionStrategy.from(spanKeys);
        }
        return SpanSuppressionStrategy.suppressNestedClients(spanKeys);
    }

    private static interface InstrumenterConstructor<RQ, RS> {
        public Instrumenter<RQ, RS> create(InstrumenterBuilder<RQ, RS> var1);

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> internal() {
            return Instrumenter::new;
        }

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> propagatingToDownstream(TextMapSetter<RQ> setter) {
            return builder -> new ClientInstrumenter(builder, setter);
        }

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> propagatingFromUpstream(TextMapGetter<RQ> getter) {
            return builder -> new ServerInstrumenter(builder, getter);
        }
    }
}

