/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpStatusConverter;
import javax.annotation.Nullable;

public final class HttpSpanStatusExtractor<REQUEST, RESPONSE>
implements SpanStatusExtractor<REQUEST, RESPONSE> {
    private final HttpStatusConverter statusConverter;
    private final HttpCommonAttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor;

    public static <REQUEST, RESPONSE> SpanStatusExtractor<REQUEST, RESPONSE> create(HttpClientAttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor) {
        return new HttpSpanStatusExtractor<REQUEST, RESPONSE>(attributesExtractor, HttpStatusConverter.CLIENT);
    }

    public static <REQUEST, RESPONSE> SpanStatusExtractor<REQUEST, RESPONSE> create(HttpServerAttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor) {
        return new HttpSpanStatusExtractor<REQUEST, RESPONSE>(attributesExtractor, HttpStatusConverter.SERVER);
    }

    private HttpSpanStatusExtractor(HttpCommonAttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor, HttpStatusConverter statusConverter) {
        this.attributesExtractor = attributesExtractor;
        this.statusConverter = statusConverter;
    }

    @Override
    public StatusCode extract(REQUEST request, @Nullable RESPONSE response, Throwable error) {
        StatusCode statusCodeObj;
        Integer statusCode;
        if (response != null && (statusCode = this.attributesExtractor.statusCode(request, response)) != null && (statusCodeObj = this.statusConverter.statusFromHttpStatus(statusCode)) == StatusCode.ERROR) {
            return statusCodeObj;
        }
        return SpanStatusExtractor.getDefault().extract(request, response, error);
    }
}

