/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.tracer;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpStatusConverter;
import io.opentelemetry.instrumentation.api.server.ServerSpan;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.instrumentation.api.tracer.SpanNames;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Deprecated
public abstract class HttpServerTracer<REQUEST, RESPONSE, CONNECTION, STORAGE>
extends BaseTracer {
    public static final String CONTEXT_ATTRIBUTE = HttpServerTracer.class.getName() + ".Context";
    protected static final String USER_AGENT = "User-Agent";

    protected HttpServerTracer() {
    }

    protected HttpServerTracer(OpenTelemetry openTelemetry) {
        super(openTelemetry);
    }

    public Context startSpan(REQUEST request, CONNECTION connection, STORAGE storage, Method origin) {
        String spanName = SpanNames.fromMethod(origin);
        return this.startSpan(request, connection, storage, spanName);
    }

    public Context startSpan(REQUEST request, CONNECTION connection, STORAGE storage, String spanName) {
        return this.startSpan(request, connection, storage, spanName, -1L);
    }

    public Context startSpan(REQUEST request, CONNECTION connection, @Nullable STORAGE storage, String spanName, long startTimestamp) {
        Context parentContext = this.extract(request, this.getGetter());
        SpanBuilder spanBuilder = this.spanBuilder(parentContext, spanName, SpanKind.SERVER);
        if (startTimestamp >= 0L) {
            spanBuilder.setStartTimestamp(startTimestamp, TimeUnit.NANOSECONDS);
        }
        this.onConnection(spanBuilder, connection);
        this.onRequest(spanBuilder, request);
        this.onConnectionAndRequest(spanBuilder, connection, request);
        Context context = this.withServerSpan(parentContext, spanBuilder.startSpan());
        context = this.customizeContext(context, request);
        this.attachServerContext(context, storage);
        return context;
    }

    protected Context customizeContext(Context context, REQUEST request) {
        return context;
    }

    public void end(Context context, RESPONSE response) {
        this.end(context, response, -1L);
    }

    public void end(Context context, RESPONSE response, long timestamp) {
        Span span = Span.fromContext((Context)context);
        HttpServerTracer.setStatus(span, this.responseStatus(response));
        this.end(context, (RESPONSE)timestamp);
    }

    @Override
    public void endExceptionally(Context context, Throwable throwable) {
        this.endExceptionally(context, throwable, null);
    }

    public void endExceptionally(Context context, Throwable throwable, RESPONSE response) {
        this.endExceptionally(context, throwable, response, -1L);
    }

    public void endExceptionally(Context context, Throwable throwable, RESPONSE response, long timestamp) {
        this.onException(context, throwable);
        Span span = Span.fromContext((Context)context);
        if (response == null) {
            HttpServerTracer.setStatus(span, 500);
        } else {
            HttpServerTracer.setStatus(span, this.responseStatus(response));
        }
        this.end(context, (RESPONSE)timestamp);
    }

    public Span getServerSpan(STORAGE storage) {
        Context attachedContext = this.getServerContext(storage);
        return attachedContext == null ? null : ServerSpan.fromContextOrNull(attachedContext);
    }

    @Nullable
    public abstract Context getServerContext(STORAGE var1);

    protected void onConnection(SpanBuilder spanBuilder, CONNECTION connection) {
        spanBuilder.setAttribute(SemanticAttributes.NET_PEER_IP, (Object)this.peerHostIp(connection));
        Integer port = this.peerPort(connection);
        if (port != null && port > 0) {
            spanBuilder.setAttribute(SemanticAttributes.NET_PEER_PORT, (Object)port);
        }
    }

    protected void onRequest(SpanBuilder spanBuilder, REQUEST request) {
        spanBuilder.setAttribute(SemanticAttributes.HTTP_METHOD, (Object)this.method(request));
        spanBuilder.setAttribute(SemanticAttributes.HTTP_USER_AGENT, (Object)this.requestHeader(request, USER_AGENT));
        String url = this.url(request);
        if (url != null) {
            spanBuilder.setAttribute(SemanticAttributes.HTTP_URL, (Object)url);
        } else {
            spanBuilder.setAttribute(SemanticAttributes.HTTP_SCHEME, (Object)this.scheme(request));
            spanBuilder.setAttribute(SemanticAttributes.HTTP_HOST, (Object)this.host(request));
            spanBuilder.setAttribute(SemanticAttributes.HTTP_TARGET, (Object)this.target(request));
        }
    }

    protected void onConnectionAndRequest(SpanBuilder spanBuilder, CONNECTION connection, REQUEST request) {
        String flavor = this.flavor(connection, request);
        if (flavor != null) {
            if (flavor.startsWith("HTTP/")) {
                flavor = flavor.substring("HTTP/".length());
            }
            spanBuilder.setAttribute(SemanticAttributes.HTTP_FLAVOR, (Object)flavor);
        }
        spanBuilder.setAttribute(SemanticAttributes.HTTP_CLIENT_IP, (Object)this.clientIp(request));
    }

    private String clientIp(REQUEST request) {
        String forwarded = this.requestHeader(request, "Forwarded");
        if (forwarded != null && (forwarded = HttpServerTracer.extractForwarded(forwarded)) != null) {
            return forwarded;
        }
        forwarded = this.requestHeader(request, "X-Forwarded-For");
        if (forwarded != null && (forwarded = HttpServerTracer.extractForwardedFor(forwarded)) != null) {
            return forwarded;
        }
        return null;
    }

    static String extractForwarded(String forwarded) {
        int start = forwarded.toLowerCase().indexOf("for=");
        if (start < 0) {
            return null;
        }
        if ((start += 4) >= forwarded.length() - 1) {
            return null;
        }
        return HttpServerTracer.extractIpAddress(forwarded, start);
    }

    static String extractForwardedFor(String forwarded) {
        return HttpServerTracer.extractIpAddress(forwarded, 0);
    }

    private static String extractIpAddress(String forwarded, int start) {
        if (forwarded.length() == start) {
            return null;
        }
        if (forwarded.charAt(start) == '\"') {
            return HttpServerTracer.extractIpAddress(forwarded, start + 1);
        }
        if (forwarded.charAt(start) == '[') {
            int end = forwarded.indexOf(93, start + 1);
            if (end == -1) {
                return null;
            }
            return forwarded.substring(start + 1, end);
        }
        boolean inIpv4 = false;
        for (int i = start; i < forwarded.length() - 1; ++i) {
            char c = forwarded.charAt(i);
            if (c == '.') {
                inIpv4 = true;
                continue;
            }
            if (c != ',' && c != ';' && c != '\"' && (!inIpv4 || c != ':')) continue;
            if (i == start) {
                return null;
            }
            return forwarded.substring(start, i);
        }
        return forwarded.substring(start);
    }

    private static void setStatus(Span span, int status) {
        span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, (Object)status);
        StatusCode statusCode = HttpStatusConverter.SERVER.statusFromHttpStatus(status);
        if (statusCode != StatusCode.UNSET) {
            span.setStatus(statusCode);
        }
    }

    @Nullable
    protected abstract Integer peerPort(CONNECTION var1);

    @Nullable
    protected abstract String peerHostIp(CONNECTION var1);

    protected abstract String flavor(CONNECTION var1, REQUEST var2);

    protected abstract TextMapGetter<REQUEST> getGetter();

    @Nullable
    protected String url(REQUEST request) {
        return null;
    }

    protected abstract String scheme(REQUEST var1);

    protected abstract String host(REQUEST var1);

    protected abstract String target(REQUEST var1);

    protected abstract String method(REQUEST var1);

    @Nullable
    protected abstract String requestHeader(REQUEST var1, String var2);

    protected abstract int responseStatus(RESPONSE var1);

    protected abstract void attachServerContext(Context var1, STORAGE var2);

    protected boolean isRelativeUrl(String url) {
        return !url.startsWith("http://") && !url.startsWith("https://");
    }
}

