/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.db;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.db.SqlStatementSanitizer;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbAttributesExtractor;
import javax.annotation.Nullable;

public abstract class SqlAttributesExtractor<REQUEST, RESPONSE>
extends DbAttributesExtractor<REQUEST, RESPONSE> {
    @Override
    public final void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        AttributeKey<String> dbTable = this.dbTableAttribute();
        if (dbTable != null) {
            this.set(attributes, dbTable, this.table(request));
        }
    }

    @Override
    @Nullable
    protected final String statement(REQUEST request) {
        return this.sanitize(request).getFullStatement();
    }

    @Override
    @Nullable
    protected final String operation(REQUEST request) {
        return this.sanitize(request).getOperation();
    }

    @Nullable
    protected final String table(REQUEST request) {
        return this.sanitize(request).getTable();
    }

    private SqlStatementInfo sanitize(REQUEST request) {
        return SqlStatementSanitizer.sanitize(this.rawStatement(request));
    }

    @Nullable
    protected abstract AttributeKey<String> dbTableAttribute();

    @Nullable
    protected abstract String rawStatement(REQUEST var1);
}

