/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.instrumentation.api.instrumenter.http.ForwarderHeaderParser;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class HttpServerAttributesExtractor<REQUEST, RESPONSE>
extends HttpCommonAttributesExtractor<REQUEST, RESPONSE, HttpServerAttributesGetter<REQUEST, RESPONSE>> {
    private final Function<Context, String> httpRouteHolderGetter;

    public static <REQUEST, RESPONSE> HttpServerAttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> getter) {
        return HttpServerAttributesExtractor.create(getter, CapturedHttpHeaders.server(Config.get()));
    }

    public static <REQUEST, RESPONSE> HttpServerAttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> getter, CapturedHttpHeaders capturedHttpHeaders) {
        return new HttpServerAttributesExtractor<REQUEST, RESPONSE>(getter, capturedHttpHeaders, HttpRouteHolder::getRoute);
    }

    HttpServerAttributesExtractor(HttpServerAttributesGetter<REQUEST, RESPONSE> getter, CapturedHttpHeaders capturedHttpHeaders, Function<Context, String> httpRouteHolderGetter) {
        super(getter, capturedHttpHeaders);
        this.httpRouteHolderGetter = httpRouteHolderGetter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        this.set(attributes, SemanticAttributes.HTTP_FLAVOR, ((HttpServerAttributesGetter)this.getter).flavor(request));
        this.set(attributes, SemanticAttributes.HTTP_SCHEME, ((HttpServerAttributesGetter)this.getter).scheme(request));
        this.set(attributes, SemanticAttributes.HTTP_HOST, this.host(request));
        this.set(attributes, SemanticAttributes.HTTP_TARGET, ((HttpServerAttributesGetter)this.getter).target(request));
        this.set(attributes, SemanticAttributes.HTTP_ROUTE, ((HttpServerAttributesGetter)this.getter).route(request));
        this.set(attributes, SemanticAttributes.HTTP_CLIENT_IP, this.clientIp(request));
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        super.onEnd(attributes, context, request, response, error);
        this.set(attributes, SemanticAttributes.HTTP_SERVER_NAME, ((HttpServerAttributesGetter)this.getter).serverName(request, response));
        this.set(attributes, SemanticAttributes.HTTP_ROUTE, this.httpRouteHolderGetter.apply(context));
    }

    @Nullable
    private String host(REQUEST request) {
        return HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).requestHeader(request, "host"));
    }

    @Nullable
    private String clientIp(REQUEST request) {
        String forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).requestHeader(request, "forwarded"));
        if (forwarded != null && (forwarded = ForwarderHeaderParser.extractForwarded(forwarded)) != null) {
            return forwarded;
        }
        forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).requestHeader(request, "x-forwarded-for"));
        if (forwarded != null) {
            return ForwarderHeaderParser.extractForwardedFor(forwarded);
        }
        return null;
    }
}

