/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.internal;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.instrumentation.api.cache.Cache;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import javax.annotation.Nullable;

public final class AsyncInstrumentRegistry {
    private static final Cache<Meter, AsyncInstrumentRegistry> asyncInstrumentRegistries = Cache.weak();
    private final WeakReference<Meter> meter;
    private final Map<String, DoubleMeasurementsRecorder> gauges = new ConcurrentHashMap<String, DoubleMeasurementsRecorder>();
    private final Map<String, DoubleMeasurementsRecorder> doubleCounters = new ConcurrentHashMap<String, DoubleMeasurementsRecorder>();
    private final Map<String, LongMeasurementsRecorder> longCounters = new ConcurrentHashMap<String, LongMeasurementsRecorder>();
    private final Map<String, DoubleMeasurementsRecorder> upDownDoubleCounters = new ConcurrentHashMap<String, DoubleMeasurementsRecorder>();

    public static AsyncInstrumentRegistry getOrCreate(Meter meter) {
        return asyncInstrumentRegistries.computeIfAbsent(meter, AsyncInstrumentRegistry::new);
    }

    AsyncInstrumentRegistry(Meter meter) {
        this.meter = new WeakReference<Meter>(meter);
    }

    public <T> AsyncMeasurementHandle buildGauge(String name, String description, String baseUnit, Attributes attributes, @Nullable T obj, ToDoubleFunction<T> objMetric) {
        DoubleMeasurementsRecorder recorder = this.gauges.computeIfAbsent(name, n -> {
            DoubleMeasurementsRecorder recorderCallback = new DoubleMeasurementsRecorder();
            this.otelMeter().gaugeBuilder(name).setDescription(description).setUnit(baseUnit).buildWithCallback((Consumer)recorderCallback);
            return recorderCallback;
        });
        recorder.addMeasurement(attributes, new DoubleMeasurementSource(obj, objMetric));
        return new AsyncMeasurementHandle(recorder, attributes);
    }

    public <T> AsyncMeasurementHandle buildDoubleCounter(String name, String description, String baseUnit, Attributes attributes, @Nullable T obj, ToDoubleFunction<T> objMetric) {
        DoubleMeasurementsRecorder recorder = this.doubleCounters.computeIfAbsent(name, n -> {
            DoubleMeasurementsRecorder recorderCallback = new DoubleMeasurementsRecorder();
            this.otelMeter().counterBuilder(name).setDescription(description).setUnit(baseUnit).ofDoubles().buildWithCallback((Consumer)recorderCallback);
            return recorderCallback;
        });
        recorder.addMeasurement(attributes, new DoubleMeasurementSource(obj, objMetric));
        return new AsyncMeasurementHandle(recorder, attributes);
    }

    public <T> AsyncMeasurementHandle buildLongCounter(String name, String description, String baseUnit, Attributes attributes, @Nullable T obj, ToLongFunction<T> objMetric) {
        LongMeasurementsRecorder recorder = this.longCounters.computeIfAbsent(name, n -> {
            LongMeasurementsRecorder recorderCallback = new LongMeasurementsRecorder();
            this.otelMeter().counterBuilder(name).setDescription(description).setUnit(baseUnit).buildWithCallback((Consumer)recorderCallback);
            return recorderCallback;
        });
        recorder.addMeasurement(attributes, new LongMeasurementSource(obj, objMetric));
        return new AsyncMeasurementHandle(recorder, attributes);
    }

    public <T> AsyncMeasurementHandle buildUpDownDoubleCounter(String name, String description, String baseUnit, Attributes attributes, T obj, ToDoubleFunction<T> objMetric) {
        DoubleMeasurementsRecorder recorder = this.upDownDoubleCounters.computeIfAbsent(name, n -> {
            DoubleMeasurementsRecorder recorderCallback = new DoubleMeasurementsRecorder();
            this.otelMeter().upDownCounterBuilder(name).setDescription(description).setUnit(baseUnit).ofDoubles().buildWithCallback((Consumer)recorderCallback);
            return recorderCallback;
        });
        recorder.addMeasurement(attributes, new DoubleMeasurementSource(obj, objMetric));
        return new AsyncMeasurementHandle(recorder, attributes);
    }

    private Meter otelMeter() {
        Meter otelMeter = (Meter)this.meter.get();
        if (otelMeter == null) {
            throw new IllegalStateException("OpenTelemetry Meter was garbage-collected, but the async instrument registry was not");
        }
        return otelMeter;
    }

    public static final class AsyncMeasurementHandle {
        private final MeasurementsRecorder<?> measurementsRecorder;
        private final Attributes attributes;

        AsyncMeasurementHandle(MeasurementsRecorder<?> measurementsRecorder, Attributes attributes) {
            this.measurementsRecorder = measurementsRecorder;
            this.attributes = attributes;
        }

        public void remove() {
            this.measurementsRecorder.removeMeasurement(this.attributes);
        }
    }

    private static final class LongMeasurementSource<T> {
        private final WeakReference<T> objWeakRef;
        private final ToLongFunction<T> metricFunction;

        private LongMeasurementSource(@Nullable T obj, ToLongFunction<T> metricFunction) {
            this.objWeakRef = new WeakReference<T>(obj);
            this.metricFunction = metricFunction;
        }
    }

    private static final class DoubleMeasurementSource<T> {
        private final WeakReference<T> objWeakRef;
        private final ToDoubleFunction<T> metricFunction;

        private DoubleMeasurementSource(@Nullable T obj, ToDoubleFunction<T> metricFunction) {
            this.objWeakRef = new WeakReference<T>(obj);
            this.metricFunction = metricFunction;
        }
    }

    private static final class LongMeasurementsRecorder
    extends MeasurementsRecorder<LongMeasurementSource<?>>
    implements Consumer<ObservableLongMeasurement> {
        private LongMeasurementsRecorder() {
        }

        @Override
        public void accept(ObservableLongMeasurement measurement) {
            this.measurements.forEach((attributes, gauge) -> LongMeasurementsRecorder.record(measurement, attributes, gauge));
        }

        private static <T> void record(ObservableLongMeasurement measurement, Attributes attributes, LongMeasurementSource<T> gauge) {
            Object obj = ((LongMeasurementSource)gauge).objWeakRef.get();
            if (obj != null) {
                measurement.record(((LongMeasurementSource)gauge).metricFunction.applyAsLong(obj), attributes);
            }
        }
    }

    private static final class DoubleMeasurementsRecorder
    extends MeasurementsRecorder<DoubleMeasurementSource<?>>
    implements Consumer<ObservableDoubleMeasurement> {
        private DoubleMeasurementsRecorder() {
        }

        @Override
        public void accept(ObservableDoubleMeasurement measurement) {
            this.measurements.forEach((attributes, gauge) -> DoubleMeasurementsRecorder.record(measurement, attributes, gauge));
        }

        private static <T> void record(ObservableDoubleMeasurement measurement, Attributes attributes, DoubleMeasurementSource<T> gauge) {
            Object obj = ((DoubleMeasurementSource)gauge).objWeakRef.get();
            if (obj != null) {
                measurement.record(((DoubleMeasurementSource)gauge).metricFunction.applyAsDouble(obj), attributes);
            }
        }
    }

    private static abstract class MeasurementsRecorder<I> {
        final Map<Attributes, I> measurements = new ConcurrentHashMap<Attributes, I>();

        private MeasurementsRecorder() {
        }

        void addMeasurement(Attributes attributes, I info) {
            this.measurements.put(attributes, info);
        }

        void removeMeasurement(Attributes attributes) {
            this.measurements.remove(attributes);
        }
    }
}

