/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.code;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.code.CodeAttributesGetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public final class CodeAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final CodeAttributesGetter<REQUEST> getter;

    public static <REQUEST, RESPONSE> CodeAttributesExtractor<REQUEST, RESPONSE> create(CodeAttributesGetter<REQUEST> getter) {
        return new CodeAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private CodeAttributesExtractor(CodeAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        Class<?> cls = this.getter.codeClass(request);
        if (cls != null) {
            this.set(attributes, SemanticAttributes.CODE_NAMESPACE, cls.getName());
        }
        this.set(attributes, SemanticAttributes.CODE_FUNCTION, this.getter.methodName(request));
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

