/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteBiGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteSource;
import io.opentelemetry.instrumentation.api.server.ServerSpan;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public final class HttpRouteHolder {
    private static final ContextKey<HttpRouteHolder> CONTEXT_KEY = ContextKey.named((String)"opentelemetry-http-server-route-key");
    private volatile int updatedBySourceOrder = 0;
    @Nullable
    private volatile String route;

    public static <REQUEST> ContextCustomizer<REQUEST> get() {
        return (context, request, startAttributes) -> {
            if (context.get(CONTEXT_KEY) != null) {
                return context;
            }
            return context.with(CONTEXT_KEY, (Object)new HttpRouteHolder());
        };
    }

    private HttpRouteHolder() {
    }

    public static void updateHttpRoute(Context context, HttpRouteSource source, @Nullable String httpRoute) {
        HttpRouteHolder.updateHttpRoute(context, source, ConstantAdapter.INSTANCE, httpRoute);
    }

    public static <T> void updateHttpRoute(Context context, HttpRouteSource source, HttpRouteGetter<T> httpRouteGetter, T arg1) {
        HttpRouteHolder.updateHttpRoute(context, source, OneArgAdapter.getInstance(), arg1, httpRouteGetter);
    }

    public static <T, U> void updateHttpRoute(Context context, HttpRouteSource source, HttpRouteBiGetter<T, U> httpRouteGetter, T arg1, U arg2) {
        String route;
        boolean onlyIfBetterRoute;
        Span serverSpan = ServerSpan.fromContextOrNull(context);
        if (serverSpan == null || !serverSpan.isRecording()) {
            return;
        }
        HttpRouteHolder httpRouteHolder = (HttpRouteHolder)context.get(CONTEXT_KEY);
        if (httpRouteHolder == null) {
            String httpRoute = httpRouteGetter.get(context, arg1, arg2);
            if (httpRoute != null && !httpRoute.isEmpty()) {
                serverSpan.updateName(httpRoute);
                serverSpan.setAttribute(SemanticAttributes.HTTP_ROUTE, (Object)httpRoute);
            }
            return;
        }
        boolean bl = onlyIfBetterRoute = !source.useFirst && source.order == httpRouteHolder.updatedBySourceOrder;
        if (!(source.order <= httpRouteHolder.updatedBySourceOrder && !onlyIfBetterRoute || (route = httpRouteGetter.get(context, arg1, arg2)) == null || route.isEmpty() || onlyIfBetterRoute && !httpRouteHolder.isBetterRoute(route))) {
            serverSpan.updateName(route);
            httpRouteHolder.updatedBySourceOrder = source.order;
            httpRouteHolder.route = route;
        }
    }

    private boolean isBetterRoute(String name) {
        String route = this.route;
        int routeLength = route == null ? 0 : route.length();
        return name.length() > routeLength;
    }

    @Nullable
    static String getRoute(Context context) {
        HttpRouteHolder httpRouteHolder = (HttpRouteHolder)context.get(CONTEXT_KEY);
        return httpRouteHolder == null ? null : httpRouteHolder.route;
    }

    private static final class ConstantAdapter
    implements HttpRouteGetter<String> {
        private static final ConstantAdapter INSTANCE = new ConstantAdapter();

        private ConstantAdapter() {
        }

        @Override
        @Nullable
        public String get(Context context, String route) {
            return route;
        }
    }

    private static final class OneArgAdapter<T>
    implements HttpRouteBiGetter<T, HttpRouteGetter<T>> {
        private static final OneArgAdapter<Object> INSTANCE = new OneArgAdapter();

        private OneArgAdapter() {
        }

        static <T> OneArgAdapter<T> getInstance() {
            return INSTANCE;
        }

        @Override
        @Nullable
        public String get(Context context, T arg, HttpRouteGetter<T> httpRouteGetter) {
            return httpRouteGetter.get(context, arg);
        }
    }
}

