/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.http.CapturedHttpHeaders;
import io.opentelemetry.instrumentation.api.instrumenter.http.ForwardedHeaderParser;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class HttpServerAttributesExtractor<REQUEST, RESPONSE>
extends HttpCommonAttributesExtractor<REQUEST, RESPONSE, HttpServerAttributesGetter<REQUEST, RESPONSE>> {
    private final Function<Context, String> httpRouteHolderGetter;

    public static <REQUEST, RESPONSE> HttpServerAttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> getter) {
        return HttpServerAttributesExtractor.builder(getter).build();
    }

    @Deprecated
    public static <REQUEST, RESPONSE> HttpServerAttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<REQUEST, RESPONSE> getter, CapturedHttpHeaders capturedHttpHeaders) {
        return HttpServerAttributesExtractor.builder(getter).captureHttpHeaders(capturedHttpHeaders).build();
    }

    public static <REQUEST, RESPONSE> HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE> builder(HttpServerAttributesGetter<REQUEST, RESPONSE> getter) {
        return new HttpServerAttributesExtractorBuilder<REQUEST, RESPONSE>(getter);
    }

    HttpServerAttributesExtractor(HttpServerAttributesGetter<REQUEST, RESPONSE> getter, CapturedHttpHeaders capturedHttpHeaders) {
        this(getter, capturedHttpHeaders, HttpRouteHolder::getRoute);
    }

    HttpServerAttributesExtractor(HttpServerAttributesGetter<REQUEST, RESPONSE> getter, CapturedHttpHeaders capturedHttpHeaders, Function<Context, String> httpRouteHolderGetter) {
        super(getter, capturedHttpHeaders);
        this.httpRouteHolderGetter = httpRouteHolderGetter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        super.onStart(attributes, parentContext, request);
        this.set(attributes, SemanticAttributes.HTTP_FLAVOR, ((HttpServerAttributesGetter)this.getter).flavor(request));
        String forwardedProto = this.forwardedProto(request);
        this.set(attributes, SemanticAttributes.HTTP_SCHEME, forwardedProto != null ? forwardedProto : ((HttpServerAttributesGetter)this.getter).scheme(request));
        this.set(attributes, SemanticAttributes.HTTP_HOST, this.host(request));
        this.set(attributes, SemanticAttributes.HTTP_TARGET, ((HttpServerAttributesGetter)this.getter).target(request));
        this.set(attributes, SemanticAttributes.HTTP_ROUTE, ((HttpServerAttributesGetter)this.getter).route(request));
        this.set(attributes, SemanticAttributes.HTTP_SERVER_NAME, ((HttpServerAttributesGetter)this.getter).serverName(request));
        this.set(attributes, SemanticAttributes.HTTP_CLIENT_IP, this.clientIp(request));
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        super.onEnd(attributes, context, request, response, error);
        this.set(attributes, SemanticAttributes.HTTP_ROUTE, this.httpRouteHolderGetter.apply(context));
    }

    @Nullable
    private String host(REQUEST request) {
        return HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).requestHeader(request, "host"));
    }

    @Nullable
    private String forwardedProto(REQUEST request) {
        String forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).requestHeader(request, "forwarded"));
        if (forwarded != null && (forwarded = ForwardedHeaderParser.extractProtoFromForwardedHeader(forwarded)) != null) {
            return forwarded;
        }
        forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).requestHeader(request, "x-forwarded-proto"));
        if (forwarded != null) {
            return ForwardedHeaderParser.extractProtoFromForwardedProtoHeader(forwarded);
        }
        return null;
    }

    @Nullable
    private String clientIp(REQUEST request) {
        String forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).requestHeader(request, "forwarded"));
        if (forwarded != null && (forwarded = ForwardedHeaderParser.extractClientIpFromForwardedHeader(forwarded)) != null) {
            return forwarded;
        }
        forwarded = HttpServerAttributesExtractor.firstHeaderValue(((HttpServerAttributesGetter)this.getter).requestHeader(request, "x-forwarded-for"));
        if (forwarded != null) {
            return ForwardedHeaderParser.extractClientIpFromForwardedForHeader(forwarded);
        }
        return null;
    }
}

