/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.db;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.db.SqlStatementSanitizer;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbAttributesExtractor;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SqlAttributesExtractor<REQUEST>
extends DbAttributesExtractor<REQUEST> {
    @Override
    protected final void onStart(AttributesBuilder attributes, REQUEST request) {
        super.onStart(attributes, request);
        AttributeKey<String> dbTable = this.dbTableAttribute();
        if (dbTable != null) {
            SqlAttributesExtractor.set(attributes, dbTable, this.table(request));
        }
    }

    @Override
    protected final @Nullable String statement(REQUEST request) {
        return this.sanitize(request).getFullStatement();
    }

    @Override
    protected final @Nullable String operation(REQUEST request) {
        return this.sanitize(request).getOperation();
    }

    protected final @Nullable String table(REQUEST request) {
        return this.sanitize(request).getTable();
    }

    private SqlStatementInfo sanitize(REQUEST request) {
        return SqlStatementSanitizer.sanitize(this.rawStatement(request));
    }

    protected abstract @Nullable AttributeKey<String> dbTableAttribute();

    protected abstract @Nullable String rawStatement(REQUEST var1);
}

