/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class HttpAttributesExtractor<REQUEST, RESPONSE>
extends AttributesExtractor<REQUEST, RESPONSE> {
    @Override
    protected final void onStart(AttributesBuilder attributes, REQUEST request) {
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_METHOD, this.method(request));
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_URL, this.url(request));
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_TARGET, this.target(request));
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_HOST, this.host(request));
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_ROUTE, this.route(request));
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_SCHEME, this.scheme(request));
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_USER_AGENT, this.userAgent(request));
    }

    @Override
    protected final void onEnd(AttributesBuilder attributes, REQUEST request, RESPONSE response) {
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH, this.requestContentLength(request, response));
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH_UNCOMPRESSED, this.requestContentLengthUncompressed(request, response));
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_STATUS_CODE, this.statusCode(request, response));
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_FLAVOR, this.flavor(request, response));
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH, this.responseContentLength(request, response));
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH_UNCOMPRESSED, this.responseContentLengthUncompressed(request, response));
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_SERVER_NAME, this.serverName(request, response));
        HttpAttributesExtractor.set(attributes, SemanticAttributes.HTTP_CLIENT_IP, this.clientIp(request, response));
    }

    protected abstract @Nullable String method(REQUEST var1);

    protected abstract @Nullable String url(REQUEST var1);

    protected abstract @Nullable String target(REQUEST var1);

    protected abstract @Nullable String host(REQUEST var1);

    protected abstract @Nullable String route(REQUEST var1);

    protected abstract @Nullable String scheme(REQUEST var1);

    protected abstract @Nullable String userAgent(REQUEST var1);

    protected abstract @Nullable Long requestContentLength(REQUEST var1, RESPONSE var2);

    protected abstract @Nullable Long requestContentLengthUncompressed(REQUEST var1, RESPONSE var2);

    protected abstract @Nullable Long statusCode(REQUEST var1, RESPONSE var2);

    protected abstract @Nullable String flavor(REQUEST var1, RESPONSE var2);

    protected abstract @Nullable Long responseContentLength(REQUEST var1, RESPONSE var2);

    protected abstract @Nullable Long responseContentLengthUncompressed(REQUEST var1, RESPONSE var2);

    protected abstract @Nullable String serverName(REQUEST var1, RESPONSE var2);

    protected abstract @Nullable String clientIp(REQUEST var1, RESPONSE var2);
}

