/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpAttributesExtractor;
import io.opentelemetry.instrumentation.api.tracer.HttpStatusConverter;

public final class HttpSpanStatusExtractor<REQUEST, RESPONSE>
implements SpanStatusExtractor<REQUEST, RESPONSE> {
    private final HttpAttributesExtractor<REQUEST, RESPONSE> attributesExtractor;

    public static <REQUEST, RESPONSE> SpanStatusExtractor<REQUEST, RESPONSE> create(HttpAttributesExtractor<REQUEST, RESPONSE> attributesExtractor) {
        return new HttpSpanStatusExtractor<REQUEST, RESPONSE>(attributesExtractor);
    }

    private HttpSpanStatusExtractor(HttpAttributesExtractor<REQUEST, RESPONSE> attributesExtractor) {
        this.attributesExtractor = attributesExtractor;
    }

    @Override
    public StatusCode extract(REQUEST request, RESPONSE response, Throwable error) {
        Long statusCode = this.attributesExtractor.statusCode(request, response);
        if (statusCode != null) {
            return HttpStatusConverter.statusFromHttpStatus(statusCode.intValue());
        }
        return SpanStatusExtractor.getDefault().extract(request, response, error);
    }
}

