/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpAttributesExtractor;

public final class HttpSpanNameExtractor<REQUEST>
implements SpanNameExtractor<REQUEST> {
    private final HttpAttributesExtractor<REQUEST, ?> attributesExtractor;

    public static <REQUEST> SpanNameExtractor<REQUEST> create(HttpAttributesExtractor<REQUEST, ?> attributesExtractor) {
        return new HttpSpanNameExtractor<REQUEST>(attributesExtractor);
    }

    private HttpSpanNameExtractor(HttpAttributesExtractor<REQUEST, ?> attributesExtractor) {
        this.attributesExtractor = attributesExtractor;
    }

    @Override
    public String extract(REQUEST request) {
        String route = this.attributesExtractor.route(request);
        if (route != null) {
            return route;
        }
        String method = this.attributesExtractor.method(request);
        if (method != null) {
            return "HTTP " + method;
        }
        return "HTTP request";
    }
}

