/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.db;

import io.opentelemetry.instrumentation.api.caching.Cache;
import io.opentelemetry.instrumentation.api.db.AutoSqlSanitizer;
import io.opentelemetry.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.instrumentation.api.db.StatementSanitizationConfig;
import io.opentelemetry.instrumentation.api.internal.SupportabilityMetrics;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SqlStatementSanitizer {
    private static final SupportabilityMetrics supportability = SupportabilityMetrics.instance();
    private static final Cache<String, SqlStatementInfo> sqlToStatementInfoCache = Cache.newBuilder().setMaximumSize(1000L).build();

    public static SqlStatementInfo sanitize(@Nullable String statement) {
        if (!StatementSanitizationConfig.isStatementSanitizationEnabled() || statement == null) {
            return SqlStatementInfo.create(statement, null, null);
        }
        return sqlToStatementInfoCache.computeIfAbsent(statement, k -> {
            supportability.incrementCounter("SqlStatementSanitizer cache miss");
            return AutoSqlSanitizer.sanitize(statement);
        });
    }

    private SqlStatementSanitizer() {
    }
}

