/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.annotations.UnstableApi;
import io.opentelemetry.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.instrumentation.api.instrumenter.RequestMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.AutoValue_HttpServerMetrics_State;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnstableApi
public final class HttpServerMetrics
implements RequestListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> HTTP_SERVER_REQUEST_METRICS_STATE = ContextKey.named((String)"http-server-request-metrics-state");
    private static final Logger logger = LoggerFactory.getLogger(HttpServerMetrics.class);
    private final LongUpDownCounter activeRequests;
    private final DoubleHistogram duration;

    @UnstableApi
    public static RequestMetrics get() {
        return HttpServerMetrics::new;
    }

    private HttpServerMetrics(Meter meter) {
        this.activeRequests = meter.upDownCounterBuilder("http.server.active_requests").setUnit("requests").setDescription("The number of concurrent HTTP requests that are currently in-flight").build();
        this.duration = meter.histogramBuilder("http.server.duration").setUnit("milliseconds").setDescription("The duration of the inbound HTTP request").build();
    }

    @Override
    public Context start(Context context, Attributes requestAttributes) {
        long startTimeNanos = System.nanoTime();
        this.activeRequests.add(1L, requestAttributes);
        return context.with(HTTP_SERVER_REQUEST_METRICS_STATE, (Object)new AutoValue_HttpServerMetrics_State(requestAttributes, startTimeNanos));
    }

    @Override
    public void end(Context context, Attributes responseAttributes) {
        State state = (State)context.get(HTTP_SERVER_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.debug("No state present when ending context {}. Cannot reset HTTP request metrics.", (Object)context);
            return;
        }
        this.activeRequests.add(-1L, state.startAttributes());
        this.duration.record((double)(System.nanoTime() - state.startTimeNanos()) / NANOS_PER_MS, state.startAttributes());
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

