/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.caching;

import io.opentelemetry.instrumentation.api.caching.Cache;
import io.opentelemetry.instrumentation.api.internal.shaded.weaklockfree.WeakConcurrentMap;
import java.util.function.Function;

final class WeakLockFreeCache<K, V>
implements Cache<K, V> {
    private final WeakConcurrentMap<K, V> delegate = new WeakConcurrentMap.WithInlinedExpunction();

    WeakLockFreeCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        V value = this.get(key);
        if (value != null) {
            return value;
        }
        WeakConcurrentMap<K, V> weakConcurrentMap = this.delegate;
        synchronized (weakConcurrentMap) {
            value = this.get(key);
            if (value != null) {
                return value;
            }
            value = mappingFunction.apply(key);
            V previous = this.delegate.putIfAbsent(key, value);
            if (previous != null) {
                return previous;
            }
            return value;
        }
    }

    @Override
    public V get(K key) {
        return this.delegate.getIfPresent(key);
    }

    @Override
    public void put(K key, V value) {
        this.delegate.put(key, value);
    }

    @Override
    public void remove(K key) {
        this.delegate.remove(key);
    }

    int size() {
        return this.delegate.approximateSize();
    }
}

