/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter;

import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKey;
import io.opentelemetry.instrumentation.api.instrumenter.db.DbAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.rpc.RpcAttributesExtractor;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class SpanKeyExtractor {
    static Set<SpanKey> determineSpanKeys(List<? extends AttributesExtractor<?, ?>> attributesExtractors) {
        HashSet<SpanKey> spanKeys = new HashSet<SpanKey>();
        for (AttributesExtractor<?, ?> attributeExtractor : attributesExtractors) {
            if (attributeExtractor instanceof HttpAttributesExtractor) {
                spanKeys.add(SpanKey.HTTP_CLIENT);
                continue;
            }
            if (attributeExtractor instanceof RpcAttributesExtractor) {
                spanKeys.add(SpanKey.RPC_CLIENT);
                continue;
            }
            if (attributeExtractor instanceof DbAttributesExtractor) {
                spanKeys.add(SpanKey.DB_CLIENT);
                continue;
            }
            if (!(attributeExtractor instanceof MessagingAttributesExtractor)) continue;
            spanKeys.add(SpanKeyExtractor.determineMessagingSpanKey((MessagingAttributesExtractor)attributeExtractor));
        }
        return spanKeys;
    }

    private static SpanKey determineMessagingSpanKey(MessagingAttributesExtractor<?, ?> messagingAttributesExtractor) {
        switch (messagingAttributesExtractor.operation()) {
            case SEND: {
                return SpanKey.PRODUCER;
            }
            case RECEIVE: {
                return SpanKey.CONSUMER_RECEIVE;
            }
            case PROCESS: {
                return SpanKey.CONSUMER_PROCESS;
            }
        }
        throw new IllegalStateException("Can't possibly happen");
    }

    private SpanKeyExtractor() {
    }
}

