/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.caching;

import io.opentelemetry.instrumentation.api.caching.Cache;
import io.opentelemetry.instrumentation.api.caching.Caffeine2Cache;
import io.opentelemetry.instrumentation.api.caching.Caffeine3Cache;
import io.opentelemetry.instrumentation.api.caching.CaffeineCache;
import io.opentelemetry.instrumentation.api.caching.WeakLockFreeCache;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public final class CacheBuilder {
    private static final long UNSET = -1L;
    private static final boolean USE_CAFFEINE_3 = Caffeine3Cache.available();
    private boolean weakKeys;
    private boolean weakValues;
    private long maximumSize = -1L;
    @Nullable
    private Executor executor = null;

    public CacheBuilder setMaximumSize(long maximumSize) {
        this.maximumSize = maximumSize;
        return this;
    }

    public CacheBuilder setWeakKeys() {
        this.weakKeys = true;
        return this;
    }

    public CacheBuilder setWeakValues() {
        this.weakValues = true;
        return this;
    }

    CacheBuilder setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public <K, V> Cache<K, V> build() {
        CaffeineCache.Builder caffeine;
        if (this.weakKeys && !this.weakValues && this.maximumSize == -1L) {
            return new WeakLockFreeCache();
        }
        CaffeineCache.Builder builder = caffeine = USE_CAFFEINE_3 ? new Caffeine3Cache.Builder() : new Caffeine2Cache.Builder();
        if (this.weakKeys) {
            caffeine.weakKeys();
        }
        if (this.weakValues) {
            caffeine.weakValues();
        }
        if (this.maximumSize != -1L) {
            caffeine.maximumSize(this.maximumSize);
        }
        if (this.executor != null) {
            caffeine.executor(this.executor);
        } else {
            caffeine.executor(Runnable::run);
        }
        return caffeine.build();
    }

    CacheBuilder() {
    }
}

