/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.servlet;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import java.util.function.Function;

public final class ServletContextPath {
    private static final ContextKey<ServletContextPath> CONTEXT_KEY = ContextKey.named((String)"opentelemetry-servlet-context-path-key");
    private final String contextPath;

    public static <REQUEST> Context init(Context context, Function<REQUEST, String> contextPathExtractor, REQUEST request) {
        ServletContextPath servletContextPath = (ServletContextPath)context.get(CONTEXT_KEY);
        if (servletContextPath != null) {
            return context;
        }
        String contextPath = contextPathExtractor.apply(request);
        if (contextPath == null) {
            return context;
        }
        if (contextPath.isEmpty() || contextPath.equals("/")) {
            contextPath = null;
        }
        return context.with(CONTEXT_KEY, (Object)new ServletContextPath(contextPath));
    }

    private ServletContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public static String prepend(Context context, String spanName) {
        String value;
        ServletContextPath servletContextPath = (ServletContextPath)context.get(CONTEXT_KEY);
        if (servletContextPath != null && (value = servletContextPath.contextPath) != null) {
            return value + spanName;
        }
        return spanName;
    }
}

