/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.cache;

import io.opentelemetry.instrumentation.api.cache.MapBackedCache;
import io.opentelemetry.instrumentation.api.cache.WeakLockFreeCache;
import io.opentelemetry.instrumentation.api.cache.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public interface Cache<K, V> {
    public static <K, V> Cache<K, V> weak() {
        return new WeakLockFreeCache();
    }

    public static <K, V> Cache<K, V> bounded(int capacity) {
        ConcurrentLinkedHashMap map = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(capacity).build();
        return new MapBackedCache(map);
    }

    public V computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    @Nullable
    public V get(K var1);

    public void put(K var1, V var2);

    public void remove(K var1);
}

