/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.tracer;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.tracer.AttributeSetter;
import io.opentelemetry.instrumentation.api.tracer.BaseTracer;
import io.opentelemetry.instrumentation.api.tracer.HttpStatusConverter;
import io.opentelemetry.instrumentation.api.tracer.net.NetPeerAttributes;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpClientTracer<REQUEST, CARRIER, RESPONSE>
extends BaseTracer {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientTracer.class);
    public static final String DEFAULT_SPAN_NAME = "HTTP request";
    protected static final String USER_AGENT = "User-Agent";
    protected final NetPeerAttributes netPeerAttributes;

    protected HttpClientTracer(NetPeerAttributes netPeerAttributes) {
        this.netPeerAttributes = netPeerAttributes;
    }

    protected HttpClientTracer(OpenTelemetry openTelemetry, NetPeerAttributes netPeerAttributes) {
        super(openTelemetry);
        this.netPeerAttributes = netPeerAttributes;
    }

    protected abstract String method(REQUEST var1);

    @Nullable
    protected abstract URI url(REQUEST var1) throws URISyntaxException;

    @Nullable
    protected String flavor(REQUEST request) {
        return "1.1";
    }

    @Nullable
    protected abstract Integer status(RESPONSE var1);

    @Nullable
    protected abstract String requestHeader(REQUEST var1, String var2);

    @Nullable
    protected abstract String responseHeader(RESPONSE var1, String var2);

    protected abstract TextMapSetter<CARRIER> getSetter();

    public boolean shouldStartSpan(Context parentContext) {
        return this.shouldStartSpan(parentContext, SpanKind.CLIENT);
    }

    public Context startSpan(Context parentContext, REQUEST request, CARRIER carrier) {
        return this.startSpan(parentContext, request, carrier, -1L);
    }

    public Context startSpan(SpanKind kind, Context parentContext, REQUEST request, CARRIER carrier, long startTimeNanos) {
        Span span = this.internalStartSpan(kind, parentContext, request, this.spanNameForRequest(request), startTimeNanos);
        Context context = this.withClientSpan(parentContext, span);
        this.inject(context, carrier);
        return context;
    }

    public Context startSpan(Context parentContext, REQUEST request, CARRIER carrier, long startTimeNanos) {
        return this.startSpan(SpanKind.CLIENT, parentContext, request, carrier, startTimeNanos);
    }

    protected void inject(Context context, CARRIER carrier) {
        TextMapSetter<CARRIER> setter = this.getSetter();
        if (setter == null) {
            throw new IllegalStateException("getSetter() not defined but calling inject(), either getSetter must be implemented or the scope should be setup manually");
        }
        this.inject(context, carrier, setter);
    }

    public void end(Context context, RESPONSE response) {
        this.end(context, response, -1L);
    }

    public void end(Context context, RESPONSE response, long endTimeNanos) {
        Span span = Span.fromContext((Context)context);
        this.onResponse(span, response);
        super.end(context, endTimeNanos);
    }

    public void endExceptionally(Context context, RESPONSE response, Throwable throwable) {
        this.endExceptionally(context, response, throwable, -1L);
    }

    public void endExceptionally(Context context, RESPONSE response, Throwable throwable, long endTimeNanos) {
        Span span = Span.fromContext((Context)context);
        this.onResponse(span, response);
        super.endExceptionally(context, throwable, endTimeNanos);
    }

    public void endMaybeExceptionally(Context context, RESPONSE response, @Nullable Throwable throwable) {
        if (throwable != null) {
            this.endExceptionally(context, throwable);
        } else {
            this.end(context, response);
        }
    }

    private Span internalStartSpan(SpanKind kind, Context parentContext, REQUEST request, String name, long startTimeNanos) {
        SpanBuilder spanBuilder = this.spanBuilder(parentContext, name, kind);
        if (startTimeNanos > 0L) {
            spanBuilder.setStartTimestamp(startTimeNanos, TimeUnit.NANOSECONDS);
        }
        this.onRequest(spanBuilder, request);
        return spanBuilder.startSpan();
    }

    protected void onRequest(SpanBuilder spanBuilder, REQUEST request) {
        this.onRequest((arg_0, arg_1) -> ((SpanBuilder)spanBuilder).setAttribute(arg_0, arg_1), request);
    }

    protected void onRequest(Span span, REQUEST request) {
        this.onRequest((arg_0, arg_1) -> ((Span)span).setAttribute(arg_0, arg_1), request);
    }

    private void onRequest(AttributeSetter setter, REQUEST request) {
        assert (setter != null);
        if (request != null) {
            setter.setAttribute(SemanticAttributes.NET_TRANSPORT, "ip_tcp");
            setter.setAttribute(SemanticAttributes.HTTP_METHOD, this.method(request));
            setter.setAttribute(SemanticAttributes.HTTP_USER_AGENT, this.requestHeader(request, USER_AGENT));
            this.setFlavor(setter, request);
            this.setUrl(setter, request);
        }
    }

    private void setFlavor(AttributeSetter setter, REQUEST request) {
        String flavor = this.flavor(request);
        if (flavor == null) {
            return;
        }
        String httpProtocolPrefix = "HTTP/";
        if (flavor.startsWith(httpProtocolPrefix)) {
            flavor = flavor.substring(httpProtocolPrefix.length());
        }
        setter.setAttribute(SemanticAttributes.HTTP_FLAVOR, flavor);
    }

    private void setUrl(AttributeSetter setter, REQUEST request) {
        try {
            URI url = this.url(request);
            if (url != null) {
                this.netPeerAttributes.setNetPeer(setter, url.getHost(), null, url.getPort());
                URI sanitized = url.getUserInfo() != null ? new URI(url.getScheme(), null, url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getFragment()) : url;
                setter.setAttribute(SemanticAttributes.HTTP_URL, sanitized.toString());
            }
        }
        catch (Exception e) {
            logger.debug("Error tagging url", (Throwable)e);
        }
    }

    protected void onResponse(Span span, RESPONSE response) {
        Integer status;
        assert (span != null);
        if (response != null && (status = this.status(response)) != null) {
            span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, (Object)status);
            StatusCode statusCode = HttpStatusConverter.CLIENT.statusFromHttpStatus(status);
            if (statusCode != StatusCode.UNSET) {
                span.setStatus(statusCode);
            }
        }
    }

    protected String spanNameForRequest(REQUEST request) {
        if (request == null) {
            return DEFAULT_SPAN_NAME;
        }
        String method = this.method(request);
        return method != null ? "HTTP " + method : DEFAULT_SPAN_NAME;
    }
}

