/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.datasource;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.jdbc.internal.DataSourceSingletons;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcUtils;
import io.opentelemetry.instrumentation.jdbc.internal.OpenTelemetryConnection;
import io.opentelemetry.instrumentation.jdbc.internal.ThrowingSupplier;
import io.opentelemetry.javaagent.bootstrap.jdbc.DbInfo;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class OpenTelemetryDataSource
implements DataSource,
AutoCloseable {
    private final DataSource delegate;

    public OpenTelemetryDataSource(DataSource delegate) {
        this.delegate = delegate;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = this.wrapCall(this.delegate::getConnection);
        DbInfo dbInfo = JdbcUtils.computeDbInfo(connection);
        return new OpenTelemetryConnection(connection, dbInfo);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        Connection connection = this.wrapCall(() -> this.delegate.getConnection(username, password));
        DbInfo dbInfo = JdbcUtils.computeDbInfo(connection);
        return new OpenTelemetryConnection(connection, dbInfo);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.delegate.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.delegate.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.delegate.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.delegate.setLoginTimeout(seconds);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.delegate.getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.delegate.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.delegate.isWrapperFor(iface);
    }

    @Override
    public void close() throws Exception {
        if (this.delegate instanceof AutoCloseable) {
            ((AutoCloseable)((Object)this.delegate)).close();
        }
    }

    private <T, E extends SQLException> T wrapCall(ThrowingSupplier<T, E> callable) throws E {
        T result;
        Context parentContext = Context.current();
        if (!Span.fromContext((Context)parentContext).getSpanContext().isValid()) {
            return callable.call();
        }
        Context context = DataSourceSingletons.instrumenter().start(parentContext, (Object)this.delegate);
        try (Scope ignored = context.makeCurrent();){
            result = callable.call();
        }
        catch (Throwable t) {
            DataSourceSingletons.instrumenter().end(context, (Object)this.delegate, null, t);
            throw t;
        }
        DataSourceSingletons.instrumenter().end(context, (Object)this.delegate, null, null);
        return result;
    }
}

