/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanLinksExtractor;
import io.opentelemetry.instrumentation.api.internal.PropagatorBasedSpanLinksExtractor;
import io.opentelemetry.instrumentation.kafka.internal.KafkaConsumerRecordGetter;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;

final class KafkaBatchProcessSpanLinksExtractor
implements SpanLinksExtractor<ConsumerRecords<?, ?>> {
    private final SpanLinksExtractor<ConsumerRecord<?, ?>> singleRecordLinkExtractor;

    KafkaBatchProcessSpanLinksExtractor(TextMapPropagator propagator) {
        this.singleRecordLinkExtractor = new PropagatorBasedSpanLinksExtractor(propagator, (TextMapGetter)KafkaConsumerRecordGetter.INSTANCE);
    }

    public void extract(SpanLinksBuilder spanLinks, Context parentContext, ConsumerRecords<?, ?> records) {
        for (ConsumerRecord record : records) {
            this.singleRecordLinkExtractor.extract(spanLinks, Context.root(), (Object)record);
        }
    }
}

