/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;

final class KafkaProducerAdditionalAttributesExtractor
implements AttributesExtractor<ProducerRecord<?, ?>, RecordMetadata> {
    private static final AttributeKey<Long> MESSAGING_KAFKA_MESSAGE_OFFSET = AttributeKey.longKey((String)"messaging.kafka.message.offset");

    KafkaProducerAdditionalAttributesExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, ProducerRecord<?, ?> producerRecord) {
        if (producerRecord.value() == null) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_TOMBSTONE, (Object)true);
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, ProducerRecord<?, ?> producerRecord, @Nullable RecordMetadata recordMetadata, @Nullable Throwable error) {
        if (recordMetadata != null) {
            attributes.put(SemanticAttributes.MESSAGING_KAFKA_PARTITION, recordMetadata.partition());
            attributes.put(MESSAGING_KAFKA_MESSAGE_OFFSET, (Object)recordMetadata.offset());
        }
    }
}

