/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafka.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import javax.annotation.Nullable;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.record.TimestampType;

public final class KafkaConsumerExperimentalAttributesExtractor
implements AttributesExtractor<ConsumerRecord<?, ?>, Void> {
    private static final AttributeKey<Long> KAFKA_OFFSET = AttributeKey.longKey((String)"kafka.offset");
    private static final AttributeKey<Long> KAFKA_RECORD_QUEUE_TIME_MS = AttributeKey.longKey((String)"kafka.record.queue_time_ms");
    private static final boolean ENABLED = Config.get().getBoolean("otel.instrumentation.kafka.experimental-span-attributes", false);

    public static boolean isEnabled() {
        return ENABLED;
    }

    public void onStart(AttributesBuilder attributes, ConsumerRecord<?, ?> consumerRecord) {
        this.set(attributes, KAFKA_OFFSET, consumerRecord.offset());
        if (consumerRecord.timestampType() != TimestampType.NO_TIMESTAMP_TYPE) {
            long produceTime = consumerRecord.timestamp();
            this.set(attributes, KAFKA_RECORD_QUEUE_TIME_MS, Math.max(0L, System.currentTimeMillis() - produceTime));
        }
    }

    public void onEnd(AttributesBuilder attributes, ConsumerRecord<?, ?> consumerRecord, @Nullable Void unused, @Nullable Throwable error) {
    }
}

