/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4.common.internal;

import io.netty.channel.ChannelHandler;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;

public final class HttpSchemeUtil {
    private static final Class<? extends ChannelHandler> sslHandlerClass = HttpSchemeUtil.getSslHandlerClass();

    private static Class<? extends ChannelHandler> getSslHandlerClass() {
        try {
            return Class.forName("io.netty.handler.ssl.SslHandler", false, HttpSchemeUtil.class.getClassLoader());
        }
        catch (ClassNotFoundException exception) {
            return null;
        }
    }

    public static String getScheme(HttpRequestAndChannel requestAndChannel) {
        return HttpSchemeUtil.isHttps(requestAndChannel) ? "https" : "http";
    }

    private static boolean isHttps(HttpRequestAndChannel requestAndChannel) {
        return sslHandlerClass != null && requestAndChannel.channel().pipeline().get(sslHandlerClass) != null;
    }

    private HttpSchemeUtil() {
    }
}

