/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4.common.internal.client;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpResponse;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.net.PeerServiceAttributesExtractor;
import io.opentelemetry.instrumentation.netty.common.internal.HttpClientSpanKeyAttributesExtractor;
import io.opentelemetry.instrumentation.netty.common.internal.NettyConnectionRequest;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.HttpRequestHeadersSetter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyConnectNetAttributesGetter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyConnectionInstrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyConnectionInstrumenterImpl;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyErrorOnlyConnectionInstrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyHttpClientAttributesGetter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyNetClientAttributesGetter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettySslErrorOnlyInstrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettySslInstrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettySslInstrumenterImpl;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettySslNetAttributesGetter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettySslRequest;
import java.util.List;
import java.util.Map;

public final class NettyClientInstrumenterFactory {
    private final OpenTelemetry openTelemetry;
    private final String instrumentationName;
    private final boolean connectionTelemetryEnabled;
    private final boolean sslTelemetryEnabled;
    private final Map<String, String> peerServiceMapping;

    public NettyClientInstrumenterFactory(OpenTelemetry openTelemetry, String instrumentationName, boolean connectionTelemetryEnabled, boolean sslTelemetryEnabled, Map<String, String> peerServiceMapping) {
        this.openTelemetry = openTelemetry;
        this.instrumentationName = instrumentationName;
        this.connectionTelemetryEnabled = connectionTelemetryEnabled;
        this.sslTelemetryEnabled = sslTelemetryEnabled;
        this.peerServiceMapping = peerServiceMapping;
    }

    public Instrumenter<HttpRequestAndChannel, HttpResponse> createHttpInstrumenter(List<String> capturedRequestHeaders, List<String> capturedResponseHeaders, List<AttributesExtractor<HttpRequestAndChannel, HttpResponse>> additionalHttpAttributeExtractors) {
        NettyHttpClientAttributesGetter httpClientAttributesGetter = new NettyHttpClientAttributesGetter();
        NettyNetClientAttributesGetter netAttributesGetter = new NettyNetClientAttributesGetter();
        return Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpClientAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpClientAttributesGetter)).addAttributesExtractor((AttributesExtractor)HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)httpClientAttributesGetter).setCapturedRequestHeaders(capturedRequestHeaders).setCapturedResponseHeaders(capturedResponseHeaders).build()).addAttributesExtractor((AttributesExtractor)NetClientAttributesExtractor.create((NetClientAttributesGetter)netAttributesGetter)).addAttributesExtractor((AttributesExtractor)PeerServiceAttributesExtractor.create((NetClientAttributesGetter)netAttributesGetter, this.peerServiceMapping)).addAttributesExtractors(additionalHttpAttributeExtractors).addOperationMetrics(HttpClientMetrics.get()).buildClientInstrumenter((TextMapSetter)HttpRequestHeadersSetter.INSTANCE);
    }

    public NettyConnectionInstrumenter createConnectionInstrumenter() {
        NettyConnectNetAttributesGetter netAttributesGetter = new NettyConnectNetAttributesGetter();
        InstrumenterBuilder instrumenterBuilder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, NettyConnectionRequest::spanName).addAttributesExtractor((AttributesExtractor)NetClientAttributesExtractor.create((NetClientAttributesGetter)netAttributesGetter)).addAttributesExtractor((AttributesExtractor)PeerServiceAttributesExtractor.create((NetClientAttributesGetter)netAttributesGetter, this.peerServiceMapping));
        if (!this.connectionTelemetryEnabled) {
            instrumenterBuilder.addAttributesExtractor((AttributesExtractor)HttpClientSpanKeyAttributesExtractor.INSTANCE);
        }
        Instrumenter instrumenter = instrumenterBuilder.buildInstrumenter(this.connectionTelemetryEnabled ? SpanKindExtractor.alwaysInternal() : SpanKindExtractor.alwaysClient());
        return this.connectionTelemetryEnabled ? new NettyConnectionInstrumenterImpl((Instrumenter<NettyConnectionRequest, Channel>)instrumenter) : new NettyErrorOnlyConnectionInstrumenter((Instrumenter<NettyConnectionRequest, Channel>)instrumenter);
    }

    public NettySslInstrumenter createSslInstrumenter() {
        NettySslNetAttributesGetter netAttributesGetter = new NettySslNetAttributesGetter();
        Instrumenter instrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)this.instrumentationName, NettySslRequest::spanName).addAttributesExtractor((AttributesExtractor)NetClientAttributesExtractor.create((NetClientAttributesGetter)netAttributesGetter)).addAttributesExtractor((AttributesExtractor)PeerServiceAttributesExtractor.create((NetClientAttributesGetter)netAttributesGetter, this.peerServiceMapping)).buildInstrumenter(this.sslTelemetryEnabled ? SpanKindExtractor.alwaysInternal() : SpanKindExtractor.alwaysClient());
        return this.sslTelemetryEnabled ? new NettySslInstrumenterImpl((Instrumenter<NettySslRequest, Void>)instrumenter) : new NettySslErrorOnlyInstrumenter((Instrumenter<NettySslRequest, Void>)instrumenter);
    }
}

