/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4.common.internal.client;

import io.netty.handler.codec.http.HttpResponse;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4.common.internal.HttpSchemeUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nullable;

final class NettyHttpClientAttributesGetter
implements HttpClientAttributesGetter<HttpRequestAndChannel, HttpResponse> {
    NettyHttpClientAttributesGetter() {
    }

    @Nullable
    public String url(HttpRequestAndChannel requestAndChannel) {
        try {
            String hostHeader = this.getHost(requestAndChannel);
            String target = requestAndChannel.request().getUri();
            URI uri = new URI(target);
            if ((uri.getHost() == null || uri.getHost().equals("")) && hostHeader != null) {
                return HttpSchemeUtil.getScheme(requestAndChannel) + "://" + hostHeader + target;
            }
            return uri.toString();
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    private String getHost(HttpRequestAndChannel requestAndChannel) {
        List<String> values = this.requestHeader(requestAndChannel, "host");
        return values.isEmpty() ? null : values.get(0);
    }

    public String flavor(HttpRequestAndChannel requestAndChannel, @Nullable HttpResponse response) {
        String flavor = requestAndChannel.request().getProtocolVersion().toString();
        if (flavor.startsWith("HTTP/")) {
            flavor = flavor.substring("HTTP/".length());
        }
        return flavor;
    }

    public String method(HttpRequestAndChannel requestAndChannel) {
        return requestAndChannel.request().getMethod().name();
    }

    public List<String> requestHeader(HttpRequestAndChannel requestAndChannel, String name) {
        return requestAndChannel.request().headers().getAll(name);
    }

    public Integer statusCode(HttpRequestAndChannel requestAndChannel, HttpResponse response, @Nullable Throwable error) {
        return response.getStatus().code();
    }

    public List<String> responseHeader(HttpRequestAndChannel requestAndChannel, HttpResponse response, String name) {
        return response.headers().getAll(name);
    }
}

