/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4.common.internal.client;

import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramChannel;
import io.opentelemetry.instrumentation.api.instrumenter.net.InetSocketAddressNetClientAttributesGetter;
import io.opentelemetry.instrumentation.netty.common.internal.NettyConnectionRequest;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import javax.annotation.Nullable;

final class NettyConnectNetAttributesGetter
extends InetSocketAddressNetClientAttributesGetter<NettyConnectionRequest, Channel> {
    NettyConnectNetAttributesGetter() {
    }

    public String transport(NettyConnectionRequest request, @Nullable Channel channel) {
        return channel instanceof DatagramChannel ? "ip_udp" : "ip_tcp";
    }

    @Nullable
    public String peerName(NettyConnectionRequest request) {
        SocketAddress requestedAddress = request.remoteAddressOnStart();
        if (requestedAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)requestedAddress).getHostString();
        }
        return null;
    }

    @Nullable
    public Integer peerPort(NettyConnectionRequest request) {
        SocketAddress requestedAddress = request.remoteAddressOnStart();
        if (requestedAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)requestedAddress).getPort();
        }
        return null;
    }

    @Nullable
    protected InetSocketAddress getPeerSocketAddress(NettyConnectionRequest request, @Nullable Channel channel) {
        if (channel == null) {
            return null;
        }
        SocketAddress remoteAddress = channel.remoteAddress();
        if (remoteAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)remoteAddress;
        }
        return null;
    }
}

