/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4.common.internal.client;

import io.netty.channel.Channel;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.internal.InstrumenterUtil;
import io.opentelemetry.instrumentation.netty.common.internal.NettyConnectionRequest;
import io.opentelemetry.instrumentation.netty.common.internal.Timer;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettyConnectionInstrumenter;
import java.time.Instant;
import javax.annotation.Nullable;

final class NettyErrorOnlyConnectionInstrumenter
implements NettyConnectionInstrumenter {
    private final Instrumenter<NettyConnectionRequest, Channel> instrumenter;

    NettyErrorOnlyConnectionInstrumenter(Instrumenter<NettyConnectionRequest, Channel> instrumenter) {
        this.instrumenter = instrumenter;
    }

    @Override
    public boolean shouldStart(Context parentContext, NettyConnectionRequest request) {
        return true;
    }

    @Override
    public Context start(Context parentContext, NettyConnectionRequest request) {
        return parentContext.with((ImplicitContextKeyed)Timer.start());
    }

    @Override
    public void end(Context context, NettyConnectionRequest request, Channel channel, @Nullable Throwable error) {
        if (error != null && this.instrumenter.shouldStart(context, (Object)request)) {
            Timer timer = Timer.get((Context)context);
            InstrumenterUtil.startAndEnd(this.instrumenter, (Context)context, (Object)request, (Object)channel, (Throwable)error, (Instant)timer.startTime(), (Instant)timer.now());
        }
    }
}

