/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4.common.internal.client;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.internal.InstrumenterUtil;
import io.opentelemetry.instrumentation.netty.common.internal.Timer;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettySslInstrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettySslRequest;
import java.time.Instant;
import javax.annotation.Nullable;

final class NettySslErrorOnlyInstrumenter
implements NettySslInstrumenter {
    private final Instrumenter<NettySslRequest, Void> instrumenter;

    NettySslErrorOnlyInstrumenter(Instrumenter<NettySslRequest, Void> instrumenter) {
        this.instrumenter = instrumenter;
    }

    @Override
    public boolean shouldStart(Context parentContext, NettySslRequest request) {
        return true;
    }

    @Override
    public Context start(Context parentContext, NettySslRequest request) {
        return parentContext.with((ImplicitContextKeyed)Timer.start());
    }

    @Override
    public void end(Context context, NettySslRequest request, @Nullable Throwable error) {
        if (error != null && this.instrumenter.shouldStart(context, (Object)request)) {
            Timer timer = Timer.get((Context)context);
            InstrumenterUtil.startAndEnd(this.instrumenter, (Context)context, (Object)request, null, (Throwable)error, (Instant)timer.startTime(), (Instant)timer.now());
        }
    }
}

