/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4.common.internal.client;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettySslInstrumenter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.client.NettySslRequest;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.net.SocketAddress;

public final class NettySslInstrumentationHandler
extends ChannelDuplexHandler {
    private static final Class<?> SSL_HANDSHAKE_COMPLETION_EVENT;
    private static final MethodHandle GET_CAUSE;
    private static final VirtualField<ChannelHandler, ChannelHandler> instrumentationHandlerField;
    private final NettySslInstrumenter instrumenter;
    private final ChannelHandler realHandler;
    private Context parentContext;
    private NettySslRequest request;
    private Context context;

    public NettySslInstrumentationHandler(NettySslInstrumenter instrumenter, ChannelHandler realHandler) {
        this.instrumenter = instrumenter;
        this.realHandler = realHandler;
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        if (SSL_HANDSHAKE_COMPLETION_EVENT == null) {
            ctx.pipeline().remove((ChannelHandler)this);
            instrumentationHandlerField.set((Object)this.realHandler, null);
            ctx.fireChannelRegistered();
            return;
        }
        this.parentContext = Context.current();
        ctx.fireChannelRegistered();
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        promise.addListener(future -> {
            if (!future.isSuccess()) {
                return;
            }
            this.request = NettySslRequest.create(ctx.channel());
            if (this.instrumenter.shouldStart(this.parentContext, this.request)) {
                this.context = this.instrumenter.start(this.parentContext, this.request);
            }
        });
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (SSL_HANDSHAKE_COMPLETION_EVENT.isInstance(evt)) {
            if (ctx.pipeline().context((ChannelHandler)this) != null) {
                ctx.pipeline().remove((ChannelHandler)this);
                instrumentationHandlerField.set((Object)this.realHandler, null);
            }
            if (this.context != null) {
                this.instrumenter.end(this.context, this.request, NettySslInstrumentationHandler.getCause(evt));
            }
        }
        ctx.fireUserEventTriggered(evt);
    }

    private static Throwable getCause(Object evt) {
        try {
            return GET_CAUSE.invoke(evt);
        }
        catch (Throwable e) {
            return null;
        }
    }

    static {
        instrumentationHandlerField = VirtualField.find(ChannelHandler.class, ChannelHandler.class);
        Class<?> sslHandshakeCompletionEvent = null;
        MethodHandle getCause = null;
        try {
            sslHandshakeCompletionEvent = Class.forName("io.netty.handler.ssl.SslHandshakeCompletionEvent", false, NettySslInstrumentationHandler.class.getClassLoader());
            getCause = MethodHandles.lookup().findVirtual(sslHandshakeCompletionEvent, "cause", MethodType.methodType(Throwable.class));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SSL_HANDSHAKE_COMPLETION_EVENT = sslHandshakeCompletionEvent;
        GET_CAUSE = getCause;
    }
}

