/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4.common.internal.server;

import io.netty.handler.codec.http.HttpResponse;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4.common.internal.HttpSchemeUtil;
import java.util.List;
import javax.annotation.Nullable;

final class NettyHttpServerAttributesGetter
implements HttpServerAttributesGetter<HttpRequestAndChannel, HttpResponse> {
    NettyHttpServerAttributesGetter() {
    }

    public String method(HttpRequestAndChannel requestAndChannel) {
        return requestAndChannel.request().getMethod().name();
    }

    public List<String> requestHeader(HttpRequestAndChannel requestAndChannel, String name) {
        return requestAndChannel.request().headers().getAll(name);
    }

    public Integer statusCode(HttpRequestAndChannel requestAndChannel, HttpResponse response, @Nullable Throwable error) {
        return response.getStatus().code();
    }

    public List<String> responseHeader(HttpRequestAndChannel requestAndChannel, HttpResponse response, String name) {
        return response.headers().getAll(name);
    }

    public String flavor(HttpRequestAndChannel requestAndChannel) {
        String flavor = requestAndChannel.request().getProtocolVersion().toString();
        if (flavor.startsWith("HTTP/")) {
            flavor = flavor.substring("HTTP/".length());
        }
        return flavor;
    }

    public String target(HttpRequestAndChannel requestAndChannel) {
        return requestAndChannel.request().getUri();
    }

    @Nullable
    public String route(HttpRequestAndChannel requestAndChannel) {
        return null;
    }

    public String scheme(HttpRequestAndChannel requestAndChannel) {
        return HttpSchemeUtil.getScheme(requestAndChannel);
    }
}

