/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.netty.v4.common.internal.server;

import io.netty.handler.codec.http.HttpResponse;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.netty.common.internal.NettyErrorHolder;
import io.opentelemetry.instrumentation.netty.v4.common.HttpRequestAndChannel;
import io.opentelemetry.instrumentation.netty.v4.common.internal.server.HttpRequestHeadersGetter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.server.NettyHttpServerAttributesGetter;
import io.opentelemetry.instrumentation.netty.v4.common.internal.server.NettyNetServerAttributesGetter;
import java.util.List;

public final class NettyServerInstrumenterFactory {
    public static Instrumenter<HttpRequestAndChannel, HttpResponse> create(OpenTelemetry openTelemetry, String instrumentationName, List<String> capturedRequestHeaders, List<String> capturedResponseHeaders) {
        NettyHttpServerAttributesGetter httpAttributesGetter = new NettyHttpServerAttributesGetter();
        return Instrumenter.builder((OpenTelemetry)openTelemetry, (String)instrumentationName, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addAttributesExtractor((AttributesExtractor)HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)httpAttributesGetter, (NetServerAttributesGetter)new NettyNetServerAttributesGetter()).setCapturedRequestHeaders(capturedRequestHeaders).setCapturedResponseHeaders(capturedResponseHeaders).build()).addOperationMetrics(HttpServerMetrics.get()).addContextCustomizer((context, request, attributes) -> NettyErrorHolder.init((Context)context)).addContextCustomizer(HttpRouteHolder.get()).buildServerInstrumenter((TextMapGetter)HttpRequestHeadersGetter.INSTANCE);
    }

    private NettyServerInstrumenterFactory() {
    }
}

