/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics;

import io.opentelemetry.api.metrics.GlobalMetricsProvider;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.common.Labels;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;

public final class GarbageCollector {
    private static final String GC_LABEL_KEY = "gc";

    public static void registerObservers() {
        List<GarbageCollectorMXBean> garbageCollectors = ManagementFactory.getGarbageCollectorMXBeans();
        Meter meter = GlobalMetricsProvider.getMeter((String)GarbageCollector.class.getName());
        ArrayList<Labels> labelSets = new ArrayList<Labels>(garbageCollectors.size());
        for (GarbageCollectorMXBean gc : garbageCollectors) {
            labelSets.add(Labels.of((String)GC_LABEL_KEY, (String)gc.getName()));
        }
        meter.longSumObserverBuilder("runtime.jvm.gc.collection").setDescription("Time spent in a given JVM garbage collector in milliseconds.").setUnit("ms").setUpdater(resultLongObserver -> {
            for (int i = 0; i < garbageCollectors.size(); ++i) {
                resultLongObserver.observe(((GarbageCollectorMXBean)garbageCollectors.get(i)).getCollectionTime(), (Labels)labelSets.get(i));
            }
        }).build();
    }

    private GarbageCollector() {
    }
}

