/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics;

import io.opentelemetry.api.metrics.AsynchronousInstrument;
import io.opentelemetry.api.metrics.GlobalMetricsProvider;
import io.opentelemetry.api.metrics.LongUpDownSumObserver;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.common.Labels;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;

public final class MemoryPools {
    private static final String TYPE_LABEL_KEY = "type";
    private static final String AREA_LABEL_KEY = "area";
    private static final String POOL_LABEL_KEY = "pool";
    private static final String USED = "used";
    private static final String COMMITTED = "committed";
    private static final String MAX = "max";
    private static final String HEAP = "heap";
    private static final String NON_HEAP = "non_heap";
    private static final Labels COMMITTED_HEAP = Labels.of((String)"type", (String)"committed", (String)"area", (String)"heap");
    private static final Labels USED_HEAP = Labels.of((String)"type", (String)"used", (String)"area", (String)"heap");
    private static final Labels MAX_HEAP = Labels.of((String)"type", (String)"max", (String)"area", (String)"heap");
    private static final Labels COMMITTED_NON_HEAP = Labels.of((String)"type", (String)"committed", (String)"area", (String)"non_heap");
    private static final Labels USED_NON_HEAP = Labels.of((String)"type", (String)"used", (String)"area", (String)"non_heap");
    private static final Labels MAX_NON_HEAP = Labels.of((String)"type", (String)"max", (String)"area", (String)"non_heap");

    public static void registerMemoryAreaObservers() {
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        Meter meter = GlobalMetricsProvider.getMeter((String)MemoryPools.class.getName());
        LongUpDownSumObserver areaMetric = meter.longUpDownSumObserverBuilder("runtime.jvm.memory.area").setDescription("Bytes of a given JVM memory area.").setUnit("By").setUpdater(resultLongObserver -> {
            MemoryPools.observeHeap(resultLongObserver, memoryBean.getHeapMemoryUsage());
            MemoryPools.observeNonHeap(resultLongObserver, memoryBean.getNonHeapMemoryUsage());
        }).build();
    }

    public static void registerMemoryPoolObservers() {
        List<MemoryPoolMXBean> poolBeans = ManagementFactory.getMemoryPoolMXBeans();
        Meter meter = GlobalMetricsProvider.getMeter((String)MemoryPools.class.getName());
        ArrayList<Labels> usedLabelSets = new ArrayList<Labels>(poolBeans.size());
        ArrayList<Labels> committedLabelSets = new ArrayList<Labels>(poolBeans.size());
        ArrayList<Labels> maxLabelSets = new ArrayList<Labels>(poolBeans.size());
        for (MemoryPoolMXBean pool : poolBeans) {
            usedLabelSets.add(Labels.of((String)TYPE_LABEL_KEY, (String)USED, (String)POOL_LABEL_KEY, (String)pool.getName()));
            committedLabelSets.add(Labels.of((String)TYPE_LABEL_KEY, (String)COMMITTED, (String)POOL_LABEL_KEY, (String)pool.getName()));
            maxLabelSets.add(Labels.of((String)TYPE_LABEL_KEY, (String)MAX, (String)POOL_LABEL_KEY, (String)pool.getName()));
        }
        meter.longUpDownSumObserverBuilder("runtime.jvm.memory.pool").setDescription("Bytes of a given JVM memory pool.").setUnit("By").setUpdater(resultLongObserver -> {
            for (int i = 0; i < poolBeans.size(); ++i) {
                MemoryUsage poolUsage = ((MemoryPoolMXBean)poolBeans.get(i)).getUsage();
                if (poolUsage == null) continue;
                MemoryPools.observe(resultLongObserver, poolUsage, (Labels)usedLabelSets.get(i), (Labels)committedLabelSets.get(i), (Labels)maxLabelSets.get(i));
            }
        }).build();
    }

    public static void registerObservers() {
        MemoryPools.registerMemoryAreaObservers();
        MemoryPools.registerMemoryPoolObservers();
    }

    static void observeHeap(AsynchronousInstrument.LongResult observer, MemoryUsage usage) {
        MemoryPools.observe(observer, usage, USED_HEAP, COMMITTED_HEAP, MAX_HEAP);
    }

    static void observeNonHeap(AsynchronousInstrument.LongResult observer, MemoryUsage usage) {
        MemoryPools.observe(observer, usage, USED_NON_HEAP, COMMITTED_NON_HEAP, MAX_NON_HEAP);
    }

    private static void observe(AsynchronousInstrument.LongResult observer, MemoryUsage usage, Labels usedLabels, Labels committedLabels, Labels maxLabels) {
        observer.observe(usage.getUsed(), usedLabels);
        observer.observe(usage.getCommitted(), committedLabels);
        if (usage.getMax() != -1L) {
            observer.observe(usage.getMax(), maxLabels);
        }
    }

    private MemoryPools() {
    }
}

