/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.aspects;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.extension.annotations.WithSpan;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class WithSpanAspect {
    private final Tracer tracer;

    public WithSpanAspect(Tracer tracer) {
        this.tracer = tracer;
    }

    @Around(value="@annotation(io.opentelemetry.extension.annotations.WithSpan)")
    public Object traceMethod(ProceedingJoinPoint pjp) throws Throwable {
        MethodSignature signature = (MethodSignature)pjp.getSignature();
        Method method = signature.getMethod();
        WithSpan withSpan = method.getAnnotation(WithSpan.class);
        Context parent = Context.current();
        Span span = this.tracer.spanBuilder(this.getSpanName(withSpan, method)).setSpanKind(withSpan.kind()).setParent(parent).startSpan();
        try {
            Object object;
            block11: {
                Scope ignored = parent.with((ImplicitContextKeyed)span).makeCurrent();
                try {
                    object = pjp.proceed();
                    if (ignored == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        span.setStatus(StatusCode.ERROR);
                        span.recordException(t);
                        throw t;
                    }
                }
                ignored.close();
            }
            return object;
        }
        finally {
            span.end();
        }
    }

    private String getSpanName(WithSpan withSpan, Method method) {
        String spanName = withSpan.value();
        if (spanName.isEmpty()) {
            return method.getDeclaringClass().getSimpleName() + "." + method.getName();
        }
        return spanName;
    }
}

