/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.aspects;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.extension.annotations.WithSpan;
import io.opentelemetry.instrumentation.spring.autoconfigure.aspects.WithSpanAspectTracer;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class WithSpanAspect {
    private final WithSpanAspectTracer tracer;

    public WithSpanAspect(OpenTelemetry openTelemetry) {
        this.tracer = new WithSpanAspectTracer(openTelemetry);
    }

    @Around(value="@annotation(io.opentelemetry.extension.annotations.WithSpan)")
    public Object traceMethod(ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        block9: {
            MethodSignature signature = (MethodSignature)pjp.getSignature();
            Method method = signature.getMethod();
            WithSpan withSpan = method.getAnnotation(WithSpan.class);
            Context parentContext = Context.current();
            if (!this.tracer.shouldStartSpan(parentContext, withSpan.kind())) {
                return pjp.proceed();
            }
            Context context = this.tracer.startSpan(parentContext, withSpan, method);
            Scope ignored = context.makeCurrent();
            try {
                Object result = pjp.proceed();
                object = this.tracer.end(context, method.getReturnType(), result);
                if (ignored == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    this.tracer.endExceptionally(context, t);
                    throw t;
                }
            }
            ignored.close();
        }
        return object;
    }
}

