/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.exporters.zipkin;

import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporterBuilder;
import io.opentelemetry.instrumentation.spring.autoconfigure.OpenTelemetryAutoConfiguration;
import io.opentelemetry.instrumentation.spring.autoconfigure.exporters.zipkin.ZipkinSpanExporterProperties;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={OpenTelemetryAutoConfiguration.class})
@EnableConfigurationProperties(value={ZipkinSpanExporterProperties.class})
@ConditionalOnProperty(prefix="otel.exporter.zipkin", name={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={ZipkinSpanExporter.class})
public class ZipkinSpanExporterAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ZipkinSpanExporter otelZipkinSpanExporter(ZipkinSpanExporterProperties properties) {
        ZipkinSpanExporterBuilder builder = ZipkinSpanExporter.builder();
        if (properties.getEndpoint() != null) {
            builder.setEndpoint(properties.getEndpoint());
        }
        return builder.build();
    }
}

