/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.autoconfigure.httpclients.webclient;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.spring.webflux.client.SpringWebfluxTracing;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.web.reactive.function.client.WebClient;

final class WebClientBeanPostProcessor
implements BeanPostProcessor {
    private final ObjectProvider<OpenTelemetry> openTelemetryProvider;

    WebClientBeanPostProcessor(ObjectProvider<OpenTelemetry> openTelemetryProvider) {
        this.openTelemetryProvider = openTelemetryProvider;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        if (bean instanceof WebClient) {
            WebClient webClient = (WebClient)bean;
            return WebClientBeanPostProcessor.wrapBuilder(this.openTelemetryProvider, webClient.mutate()).build();
        }
        if (bean instanceof WebClient.Builder) {
            WebClient.Builder webClientBuilder = (WebClient.Builder)bean;
            return WebClientBeanPostProcessor.wrapBuilder(this.openTelemetryProvider, webClientBuilder);
        }
        return bean;
    }

    private static WebClient.Builder wrapBuilder(ObjectProvider<OpenTelemetry> openTelemetryProvider, WebClient.Builder webClientBuilder) {
        OpenTelemetry openTelemetry = (OpenTelemetry)openTelemetryProvider.getIfUnique();
        if (openTelemetry != null) {
            SpringWebfluxTracing instrumentation = SpringWebfluxTracing.create((OpenTelemetry)openTelemetry);
            return webClientBuilder.filters(arg_0 -> ((SpringWebfluxTracing)instrumentation).addClientTracingFilter(arg_0));
        }
        return webClientBuilder;
    }
}

